/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.presign;

import java.net.URI;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.SdkClock;
import software.amazon.awssdk.runtime.auth.SignerProvider;

@Immutable
@SdkProtectedApi
public class PresignerParams {
    private final URI endpoint;
    private final AwsCredentialsProvider credentialsProvider;
    private final SignerProvider signerProvider;
    private final SdkClock clock;

    public PresignerParams(URI endpoint, AwsCredentialsProvider credentialsProvider, SignerProvider signerProvider, SdkClock clock) {
        this.endpoint = endpoint;
        this.credentialsProvider = credentialsProvider;
        this.signerProvider = signerProvider;
        this.clock = clock;
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI endpoint() {
        return this.endpoint;
    }

    public AwsCredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    public SignerProvider signerProvider() {
        return this.signerProvider;
    }

    public SdkClock clock() {
        return this.clock;
    }

    public static class Builder {
        private URI endpoint;
        private AwsCredentialsProvider credentialsProvider;
        private SignerProvider signerProvider;
        private SdkClock clock;

        private Builder() {
        }

        public Builder endpoint(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder signerProvider(SignerProvider signerProvider) {
            this.signerProvider = signerProvider;
            return this;
        }

        @SdkTestInternalApi
        public Builder clock(SdkClock clock) {
            this.clock = clock;
            return this;
        }

        public PresignerParams build() {
            return new PresignerParams(this.endpoint, this.credentialsProvider, this.signerProvider, this.resolveClock());
        }

        private SdkClock resolveClock() {
            return this.clock == null ? SdkClock.STANDARD : this.clock;
        }
    }
}

