/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerImpl;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.internal.AmazonWebServiceRequestAdapter;
import software.amazon.awssdk.internal.http.response.AwsErrorResponseHandler;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;

@ThreadSafe
@Immutable
public class SdkClientHandler
extends ClientHandler {
    private final ClientHandler delegateHandler;

    public SdkClientHandler(ClientHandlerParams handlerParams) {
        this.delegateHandler = new ClientHandlerImpl(handlerParams);
    }

    @Override
    public <InputT, OutputT> OutputT execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        return this.delegateHandler.execute(this.addRequestConfig(executionParams).withErrorResponseHandler(new AwsErrorResponseHandler(executionParams.getErrorResponseHandler(), new AwsRequestMetrics())));
    }

    @Override
    public void close() throws Exception {
        this.delegateHandler.close();
    }

    private <InputT, OutputT> ClientExecutionParams<InputT, OutputT> addRequestConfig(ClientExecutionParams<InputT, OutputT> params) {
        return params.withRequestConfig(new AmazonWebServiceRequestAdapter((AmazonWebServiceRequest)params.getInput()));
    }
}

