/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.builder.AwsClientBuilder;
import software.amazon.awssdk.client.builder.ExecutorFactory;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

@NotThreadSafe
@SdkProtectedApi
public abstract class AwsAsyncClientBuilder<SubclassT extends AwsAsyncClientBuilder, TypeToBuildT>
extends AwsClientBuilder<SubclassT, TypeToBuildT> {
    private ExecutorFactory executorFactory;

    protected AwsAsyncClientBuilder() {
    }

    @SdkTestInternalApi
    protected AwsAsyncClientBuilder(AwsRegionProvider regionProvider) {
        super(regionProvider);
    }

    public final ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public final void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public final SubclassT withExecutorFactory(ExecutorFactory executorFactory) {
        this.setExecutorFactory(executorFactory);
        return (SubclassT)((AwsAsyncClientBuilder)this.getSubclass());
    }

    @Override
    public final TypeToBuildT build() {
        return this.build(this.getAsyncClientParams());
    }

    protected abstract TypeToBuildT build(AwsAsyncClientParams var1);

    protected final AwsAsyncClientParams getAsyncClientParams() {
        return new AsyncBuilderParams(this.executorFactory);
    }

    protected class AsyncBuilderParams
    extends AwsClientBuilder.SyncBuilderParams {
        private final ScheduledExecutorService executorService;

        protected AsyncBuilderParams(ExecutorFactory executorFactory) {
            super(AwsAsyncClientBuilder.this);
            this.executorService = Executors.newScheduledThreadPool(5);
        }

        @Override
        public ScheduledExecutorService getExecutor() {
            return this.executorService;
        }

        private ExecutorService defaultExecutor() {
            return Executors.newFixedThreadPool(50);
        }
    }
}

