/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client.builder;

import java.util.Optional;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpClientFactory;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@ReviewBeforeRelease(value="Do we want this approach to force mutual exclusion or should we flatten it out and do mutex checks at runtime?")
public final class ClientHttpConfiguration
implements ToCopyableBuilder<Builder, ClientHttpConfiguration> {
    private final SdkHttpClient httpClient;
    private final SdkHttpClientFactory httpClientFactory;

    private ClientHttpConfiguration(DefaultHttpConfigurationBuilder builder) {
        this.httpClient = builder.httpClient;
        this.httpClientFactory = builder.httpClientFactory;
    }

    public Optional<SdkHttpClient> httpClient() {
        return Optional.ofNullable(this.httpClient);
    }

    public Optional<SdkHttpClientFactory> httpClientFactory() {
        return Optional.ofNullable(this.httpClientFactory);
    }

    public Builder toBuilder() {
        return new DefaultHttpConfigurationBuilder().httpClient(this.httpClient).httpClientFactory(this.httpClientFactory);
    }

    @SdkInternalApi
    Optional<Either<SdkHttpClient, SdkHttpClientFactory>> toEither() {
        if (this.httpClient != null) {
            return Optional.of(Either.left((Object)this.httpClient));
        }
        if (this.httpClientFactory != null) {
            return Optional.of(Either.right((Object)this.httpClientFactory));
        }
        return Optional.empty();
    }

    public static Builder builder() {
        return new DefaultHttpConfigurationBuilder();
    }

    private static final class DefaultHttpConfigurationBuilder
    implements Builder {
        private SdkHttpClient httpClient;
        private SdkHttpClientFactory httpClientFactory;

        private DefaultHttpConfigurationBuilder() {
        }

        public DefaultHttpConfigurationBuilder httpClient(SdkHttpClient sdkHttpClient) {
            this.httpClient = sdkHttpClient;
            return this;
        }

        public void setHttpClient(SdkHttpClient httpClient) {
            this.httpClient(httpClient);
        }

        public DefaultHttpConfigurationBuilder httpClientFactory(SdkHttpClientFactory sdkClientFactory) {
            this.httpClientFactory = sdkClientFactory;
            return this;
        }

        public void setHttpClientFactory(SdkHttpClientFactory httpClientFactory) {
            this.httpClientFactory(httpClientFactory);
        }

        public ClientHttpConfiguration build() {
            return new ClientHttpConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClientHttpConfiguration> {
        public SdkBuilder<?, ClientHttpConfiguration> httpClient(SdkHttpClient var1);

        public SdkBuilder<?, ClientHttpConfiguration> httpClientFactory(SdkHttpClientFactory var1);
    }
}

