/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.config.defaults;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.config.AdvancedClientOption;
import software.amazon.awssdk.config.ClientOverrideConfiguration;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.retry.PredefinedRetryPolicies;
import software.amazon.awssdk.util.VersionInfoUtils;

@SdkInternalApi
public final class GlobalClientConfigurationDefaults
extends ClientConfigurationDefaults {
    @ReviewBeforeRelease(value="Load test this to make sure it's appropriate.")
    public static final int DEFAULT_ASYNC_POOL_SIZE = 1;

    @Override
    protected void applyOverrideDefaults(ClientOverrideConfiguration.Builder builder) {
        ClientOverrideConfiguration configuration = (ClientOverrideConfiguration)builder.build();
        builder.gzipEnabled(this.applyDefault(configuration.gzipEnabled(), () -> false));
        builder.advancedOption(AdvancedClientOption.USER_AGENT_PREFIX, this.applyDefault(configuration.advancedOption(AdvancedClientOption.USER_AGENT_PREFIX), VersionInfoUtils::getUserAgent));
        builder.advancedOption(AdvancedClientOption.USER_AGENT_SUFFIX, this.applyDefault(configuration.advancedOption(AdvancedClientOption.USER_AGENT_SUFFIX), () -> ""));
        builder.requestMetricCollector(this.applyDefault(configuration.requestMetricCollector(), () -> RequestMetricCollector.NONE));
        builder.retryPolicy(this.applyDefault(configuration.retryPolicy(), () -> PredefinedRetryPolicies.DEFAULT));
    }

    @Override
    protected ScheduledExecutorService getAsyncExecutorDefault() {
        return Executors.newScheduledThreadPool(1);
    }
}

