/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.config.defaults;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.config.AdvancedClientOption;
import software.amazon.awssdk.config.ClientOverrideConfiguration;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.handlers.HandlerChainFactory;
import software.amazon.awssdk.runtime.auth.SignerProvider;

@SdkProtectedApi
public class ServiceBuilderConfigurationDefaults
extends ClientConfigurationDefaults {
    private final Supplier<SignerProvider> defaultSignerProvider;
    private final Supplier<URI> defaultEndpoint;
    private final List<String> requestHandlerPaths;

    private ServiceBuilderConfigurationDefaults(Builder builder) {
        this.defaultSignerProvider = builder.defaultSignerProvider;
        this.defaultEndpoint = builder.defaultEndpoint;
        this.requestHandlerPaths = new ArrayList<String>(builder.requestHandlerPaths);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyOverrideDefaults(ClientOverrideConfiguration.Builder builder) {
        ClientOverrideConfiguration config = (ClientOverrideConfiguration)builder.build();
        builder.advancedOption(AdvancedClientOption.SIGNER_PROVIDER, this.applyDefault(config.advancedOption(AdvancedClientOption.SIGNER_PROVIDER), this.defaultSignerProvider));
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlerPaths.forEach(path -> chainFactory.newRequestHandlerChain((String)path).forEach(builder::addRequestListener));
    }

    @Override
    protected URI getEndpointDefault() {
        return this.defaultEndpoint.get();
    }

    public static final class Builder {
        private Supplier<SignerProvider> defaultSignerProvider;
        private Supplier<URI> defaultEndpoint;
        private List<String> requestHandlerPaths = new ArrayList<String>();

        private Builder() {
        }

        public Builder defaultSignerProvider(Supplier<SignerProvider> defaultSignerProvider) {
            this.defaultSignerProvider = defaultSignerProvider;
            return this;
        }

        public Builder defaultEndpoint(Supplier<URI> endpoint) {
            this.defaultEndpoint = endpoint;
            return this;
        }

        public Builder addRequestHandlerPath(String handlerPath) {
            this.requestHandlerPaths.add(handlerPath);
            return this;
        }

        public ServiceBuilderConfigurationDefaults build() {
            return new ServiceBuilderConfigurationDefaults(this);
        }
    }
}

