/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkPublicApi;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.http.SdkHttpFullRequest;

@SdkPublicApi
public class HttpResponse
implements Abortable {
    private final SdkHttpFullRequest request;
    private final Abortable abortable;
    private String statusText;
    private int statusCode;
    private InputStream content;
    private Map<String, String> headers = new HashMap<String, String>();

    public HttpResponse(SdkHttpFullRequest request) {
        this(request, null);
    }

    public HttpResponse(SdkHttpFullRequest request, Abortable abortable) {
        this.request = request;
        this.abortable = abortable;
    }

    public SdkHttpFullRequest getRequest() {
        return this.request;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String headerName) {
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            if (!header.getKey().equalsIgnoreCase(headerName)) continue;
            return header.getValue();
        }
        return null;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public InputStream getContent() {
        return this.content;
    }

    public void setContent(InputStream content) {
        this.content = content;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public boolean isSuccessful() {
        return this.statusCode / 100 == 2;
    }

    public void abort() {
        if (this.abortable != null) {
            this.abortable.abort();
        }
    }
}

