/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.async.AsyncResponseHandler;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponseAdapter;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.async.UnmarshallingAsyncResponseHandler;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.runtime.transform.UnmarshallingStreamingResponseHandler;
import software.amazon.awssdk.runtime.transform.VoidStaxUnmarshaller;
import software.amazon.awssdk.sync.StreamingResponseHandler;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkProtectedApi
@ReviewBeforeRelease(value="Metadata is currently broken. Revisit when base result types are refactored")
public class StaxResponseHandler<T>
implements HttpResponseHandler<T> {
    private static final Logger log = LoggerFactory.getLogger((String)"software.amazon.awssdk.request");
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T handle(HttpResponse response) throws Exception {
        XMLEventReader eventReader;
        log.trace("Parsing service response XML");
        InputStream content = response.getContent();
        if (content == null) {
            content = new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8));
        }
        XMLInputFactory xMLInputFactory = XML_INPUT_FACTORY;
        synchronized (xMLInputFactory) {
            eventReader = XML_INPUT_FACTORY.createXMLEventReader(content);
        }
        try {
            StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, response.getHeaders());
            unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
            unmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T t = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            return t;
        }
        finally {
            try {
                eventReader.close();
            }
            catch (XMLStreamException e) {
                log.warn("Error closing xml parser", (Throwable)e);
            }
        }
    }

    protected ResponseMetadata getResponseMetadata(Map<String, String> metadata) {
        return new ResponseMetadata(metadata);
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    public static <ResponseT, ReturnT> HttpResponseHandler<ReturnT> createStreamingResponseHandler(Unmarshaller<ResponseT, StaxUnmarshallerContext> unmarshaller, StreamingResponseHandler<ResponseT, ReturnT> streamingHandler) {
        FunctionalUtils.UnsafeFunction unmarshallFunction = response -> StaxResponseHandler.unmarshallStreaming(unmarshaller, response);
        return new UnmarshallingStreamingResponseHandler<ResponseT, ReturnT>(streamingHandler, unmarshallFunction);
    }

    public static <ResponseT, ReturnT> SdkHttpResponseHandler<ReturnT> createStreamingAsyncResponseHandler(Unmarshaller<ResponseT, StaxUnmarshallerContext> unmarshaller, AsyncResponseHandler<ResponseT, ReturnT> asyncResponseHandler) {
        return new UnmarshallingAsyncResponseHandler<ResponseT, ReturnT>(asyncResponseHandler, sdkHttpResponse -> {
            HttpResponse httpResponse = SdkHttpResponseAdapter.adapt(false, null, (SdkHttpFullResponse)sdkHttpResponse);
            return StaxResponseHandler.unmarshallStreaming(unmarshaller, httpResponse);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <ResponseT> ResponseT unmarshallStreaming(Unmarshaller<ResponseT, StaxUnmarshallerContext> unmarshaller, HttpResponse response) throws Exception {
        XMLEventReader eventReader;
        XMLInputFactory xMLInputFactory = XML_INPUT_FACTORY;
        synchronized (xMLInputFactory) {
            eventReader = (XMLEventReader)FunctionalUtils.invokeSafely(() -> XML_INPUT_FACTORY.createXMLEventReader(new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8))));
        }
        StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, response.getHeaders());
        unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
        unmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
        return unmarshaller.unmarshall(unmarshallerContext);
    }
}

