/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.event.ProgressEventType;
import software.amazon.awssdk.event.ProgressInputStream;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.event.SdkProgressPublisher;
import software.amazon.awssdk.http.AmazonHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.pipeline.RequestPipeline;
import software.amazon.awssdk.runtime.io.ReleasableInputStream;
import software.amazon.awssdk.runtime.io.ResettableInputStream;
import software.amazon.awssdk.runtime.io.SdkBufferedInputStream;
import software.amazon.awssdk.util.UnreliableFilterInputStream;
import software.amazon.awssdk.utils.IoUtils;

public class StreamManagingStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, Response<OutputT>> {
    private static final Logger log = LoggerFactory.getLogger(StreamManagingStage.class);
    private final RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped;

    public StreamManagingStage(RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped) {
        this.wrapped = wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<OutputT> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        InputStream toBeClosed = this.createManagedStream(request, context.requestConfig());
        try {
            ProgressListener listener = context.requestConfig().getProgressListener();
            SdkProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_STARTED_EVENT);
            Response<OutputT> response = this.wrapped.execute((SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).content(this.nonCloseableInputStream(toBeClosed)).build(), context);
            SdkProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_SUCCESS_EVENT);
            context.awsRequestMetrics().getTimingInfo().endTiming();
            Response<OutputT> response2 = response;
            return response2;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)toBeClosed, (Logger)log);
        }
    }

    private InputStream nonCloseableInputStream(InputStream toBeClosed) {
        return toBeClosed == null ? null : (InputStream)ReleasableInputStream.wrap(toBeClosed).disableClose();
    }

    private InputStream createManagedStream(SdkHttpFullRequest request, RequestConfig requestConfig) {
        if (request.getContent() == null) {
            return null;
        }
        InputStream content = this.monitorStreamProgress(requestConfig.getProgressListener(), this.bufferIfNeeded(this.makeResettable(request.getContent())));
        return AmazonHttpClient.unreliableTestConfig == null ? content : this.wrapWithUnreliableStream(content);
    }

    private InputStream makeResettable(InputStream content) {
        block3: {
            if (!content.markSupported() && content instanceof FileInputStream) {
                try {
                    return new ResettableInputStream((FileInputStream)content);
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("For the record; ignore otherwise", (Throwable)e);
                }
            }
        }
        return content;
    }

    private InputStream bufferIfNeeded(InputStream content) {
        return content.markSupported() ? content : new SdkBufferedInputStream(content);
    }

    private InputStream monitorStreamProgress(ProgressListener listener, InputStream content) {
        return ProgressInputStream.inputStreamForRequest(content, listener);
    }

    private InputStream wrapWithUnreliableStream(InputStream content) {
        return new UnreliableFilterInputStream(content, AmazonHttpClient.unreliableTestConfig.isFakeIoException()).withBytesReadBeforeException(AmazonHttpClient.unreliableTestConfig.getBytesReadBeforeException()).withMaxNumErrors(AmazonHttpClient.unreliableTestConfig.getMaxNumErrors()).withResetIntervalBeforeException(AmazonHttpClient.unreliableTestConfig.getResetIntervalBeforeException());
    }
}

