/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.async;

import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.async.AsyncResponseHandler;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.util.Throwables;
import software.amazon.awssdk.utils.FunctionalUtils;

public class UnmarshallingAsyncResponseHandler<ResponseT, ReturnT>
implements SdkHttpResponseHandler<ReturnT> {
    private final AsyncResponseHandler<ResponseT, ReturnT> asyncResponseHandler;
    private final FunctionalUtils.UnsafeFunction<SdkHttpResponse, ResponseT> unmarshaller;

    public UnmarshallingAsyncResponseHandler(AsyncResponseHandler<ResponseT, ReturnT> asyncResponseHandler, FunctionalUtils.UnsafeFunction<SdkHttpResponse, ResponseT> unmarshaller) {
        this.asyncResponseHandler = asyncResponseHandler;
        this.unmarshaller = unmarshaller;
    }

    public void headersReceived(SdkHttpResponse response) {
        try {
            this.asyncResponseHandler.responseReceived(this.unmarshaller.apply((Object)response));
        }
        catch (Exception e) {
            throw Throwables.failure(e);
        }
    }

    public void onStream(Publisher<ByteBuffer> publisher) {
        this.asyncResponseHandler.onStream(publisher);
    }

    public void exceptionOccurred(Throwable throwable) {
        this.asyncResponseHandler.exceptionOccurred(throwable);
    }

    public ReturnT complete() {
        return this.asyncResponseHandler.complete();
    }
}

