/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.http.HttpClientDependencies;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.pipeline.MutableRequestToRequestPipeline;

public class MergeCustomHeadersStage
implements MutableRequestToRequestPipeline {
    private final LegacyClientConfiguration config;

    public MergeCustomHeadersStage(HttpClientDependencies dependencies) {
        this.config = dependencies.config();
    }

    @Override
    public SdkHttpFullRequest.Builder execute(SdkHttpFullRequest.Builder request, RequestExecutionContext context) throws Exception {
        return request.headers(this.adaptHeaders(this.config.getHeaders())).headers(this.adaptHeaders(context.requestConfig().getCustomRequestHeaders()));
    }

    private Map<String, List<String>> adaptHeaders(Map<String, String> toConvert) {
        HashMap<String, List<String>> adapted = new HashMap<String, List<String>>(toConvert.size());
        toConvert.forEach((k, v) -> adapted.put((String)k, Collections.singletonList(v)));
        return adapted;
    }
}

