/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.event.SdkProgressPublisher;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.StreamManagingStage;
import software.amazon.awssdk.http.pipeline.RequestToRequestPipeline;

public class ReportRequestContentLengthStage
implements RequestToRequestPipeline {
    private static final Logger log = LoggerFactory.getLogger(StreamManagingStage.class);

    @Override
    public SdkHttpFullRequest execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        try {
            request.getFirstHeaderValue("Content-Length").map(Long::parseLong).ifPresent(l -> SdkProgressPublisher.publishRequestContentLength(context.requestConfig().getProgressListener(), l));
        }
        catch (NumberFormatException e) {
            log.warn("Cannot parse the Content-Length header of the request.");
        }
        return request;
    }
}

