/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.internal.net.ConnectionUtils;
import software.amazon.awssdk.retry.internal.CredentialsEndpointRetryParameters;
import software.amazon.awssdk.retry.internal.CredentialsEndpointRetryPolicy;
import software.amazon.awssdk.util.json.Jackson;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
public final class EC2CredentialsUtils {
    private static final Logger log = LoggerFactory.getLogger(EC2CredentialsUtils.class);
    private static volatile EC2CredentialsUtils instance;
    private final ConnectionUtils connectionUtils;

    private EC2CredentialsUtils() {
        this(ConnectionUtils.getInstance());
    }

    EC2CredentialsUtils(ConnectionUtils connectionUtils) {
        this.connectionUtils = connectionUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EC2CredentialsUtils getInstance() {
        if (instance != null) return instance;
        Class<EC2CredentialsUtils> clazz = EC2CredentialsUtils.class;
        synchronized (EC2CredentialsUtils.class) {
            if (instance != null) return instance;
            instance = new EC2CredentialsUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String readResource(URI endpoint) throws IOException {
        return this.readResource(endpoint, CredentialsEndpointRetryPolicy.NO_RETRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readResource(URI endpoint, CredentialsEndpointRetryPolicy retryPolicy) throws IOException {
        int retriesAttempted = 0;
        InputStream inputStream = null;
        while (true) {
            block9: {
                int statusCode;
                HttpURLConnection connection;
                block8: {
                    connection = this.connectionUtils.connectToEndpoint(endpoint);
                    statusCode = connection.getResponseCode();
                    if (statusCode != 200) break block8;
                    inputStream = connection.getInputStream();
                    String string = IoUtils.toString((InputStream)inputStream);
                    IoUtils.closeQuietly((AutoCloseable)inputStream, (Logger)log);
                    return string;
                }
                try {
                    if (statusCode == 404) {
                        throw new SdkClientException("The requested metadata is not found at " + connection.getURL());
                    }
                    if (retryPolicy.shouldRetry(retriesAttempted++, CredentialsEndpointRetryParameters.builder().withStatusCode(statusCode).build())) break block9;
                    inputStream = connection.getErrorStream();
                    this.handleErrorResponse(inputStream, statusCode, connection.getResponseMessage());
                }
                catch (IOException ioException) {
                    try {
                        if (!retryPolicy.shouldRetry(retriesAttempted++, CredentialsEndpointRetryParameters.builder().withException(ioException).build())) {
                            throw ioException;
                        }
                        log.debug("An IOException occurred when connecting to endpoint: {} \n Retrying to connect again", (Object)endpoint);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(inputStream, (Logger)log);
                        throw throwable;
                    }
                    IoUtils.closeQuietly((AutoCloseable)inputStream, (Logger)log);
                    continue;
                }
            }
            IoUtils.closeQuietly((AutoCloseable)inputStream, (Logger)log);
            continue;
            break;
        }
    }

    private void handleErrorResponse(InputStream errorStream, int statusCode, String responseMessage) throws IOException {
        String errorCode = null;
        if (errorStream != null) {
            String errorResponse = IoUtils.toString((InputStream)errorStream);
            try {
                JsonNode node = Jackson.jsonNodeOf(errorResponse);
                JsonNode code = node.get("code");
                JsonNode message = node.get("message");
                if (code != null && message != null) {
                    errorCode = code.asText();
                    responseMessage = message.asText();
                }
            }
            catch (RuntimeException exception) {
                log.debug("Unable to parse error stream", (Throwable)exception);
            }
        }
        AmazonServiceException ase = new AmazonServiceException(responseMessage);
        ase.setStatusCode(statusCode);
        ase.setErrorCode(errorCode);
        throw ase;
    }
}

