/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.OperationInfo;
import software.amazon.awssdk.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.protocol.json.StructuredJsonGenerator;
import software.amazon.awssdk.protocol.json.internal.HeaderMarshallers;
import software.amazon.awssdk.protocol.json.internal.JsonMarshaller;
import software.amazon.awssdk.protocol.json.internal.JsonMarshallerContext;
import software.amazon.awssdk.protocol.json.internal.MarshallerRegistry;
import software.amazon.awssdk.protocol.json.internal.QueryParamMarshallers;
import software.amazon.awssdk.protocol.json.internal.SimpleTypeJsonMarshallers;
import software.amazon.awssdk.protocol.json.internal.SimpleTypePathMarshallers;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkInternalApi
public class JsonProtocolMarshaller<OrigRequestT>
implements ProtocolRequestMarshaller<OrigRequestT> {
    private static final MarshallerRegistry MARSHALLER_REGISTRY = JsonProtocolMarshaller.createMarshallerRegistry();
    private final StructuredJsonGenerator jsonGenerator;
    private final Request<OrigRequestT> request;
    private final String contentType;
    private final boolean hasExplicitPayloadMember;
    private final JsonMarshallerContext marshallerContext;

    public JsonProtocolMarshaller(StructuredJsonGenerator jsonGenerator, String contentType, OperationInfo operationInfo, OrigRequestT originalRequest) {
        this.jsonGenerator = jsonGenerator;
        this.contentType = contentType;
        this.hasExplicitPayloadMember = operationInfo.hasExplicitPayloadMember();
        this.request = this.fillBasicRequestParams(operationInfo, originalRequest);
        this.marshallerContext = JsonMarshallerContext.builder().jsonGenerator(jsonGenerator).marshallerRegistry(MARSHALLER_REGISTRY).protocolHandler(this).request(this.request).build();
    }

    private Request<OrigRequestT> fillBasicRequestParams(OperationInfo operationInfo, OrigRequestT originalRequest) {
        DefaultRequest<OrigRequestT> request = this.createRequest(operationInfo, originalRequest);
        request.setHttpMethod(operationInfo.httpMethodName());
        request.setResourcePath(UriResourcePathUtils.addStaticQueryParamtersToRequest(request, operationInfo.requestUri()));
        if (operationInfo.operationIdentifier() != null) {
            request.addHeader("X-Amz-Target", operationInfo.operationIdentifier());
        }
        return request;
    }

    private DefaultRequest<OrigRequestT> createRequest(OperationInfo operationInfo, OrigRequestT originalRequest) {
        if (originalRequest instanceof AmazonWebServiceRequest) {
            return new DefaultRequest((AmazonWebServiceRequest)originalRequest, operationInfo.serviceName());
        }
        return new DefaultRequest(operationInfo.serviceName());
    }

    private static MarshallerRegistry createMarshallerRegistry() {
        return MarshallerRegistry.builder().payloadMarshaller(MarshallingType.STRING, SimpleTypeJsonMarshallers.STRING).payloadMarshaller(MarshallingType.INTEGER, SimpleTypeJsonMarshallers.INTEGER).payloadMarshaller(MarshallingType.LONG, SimpleTypeJsonMarshallers.LONG).payloadMarshaller(MarshallingType.DOUBLE, SimpleTypeJsonMarshallers.DOUBLE).payloadMarshaller(MarshallingType.FLOAT, SimpleTypeJsonMarshallers.FLOAT).payloadMarshaller(MarshallingType.BIG_DECIMAL, SimpleTypeJsonMarshallers.BIG_DECIMAL).payloadMarshaller(MarshallingType.BOOLEAN, SimpleTypeJsonMarshallers.BOOLEAN).payloadMarshaller(MarshallingType.INSTANT, SimpleTypeJsonMarshallers.INSTANT).payloadMarshaller(MarshallingType.BYTE_BUFFER, SimpleTypeJsonMarshallers.BYTE_BUFFER).payloadMarshaller(MarshallingType.STRUCTURED, SimpleTypeJsonMarshallers.STRUCTURED).payloadMarshaller(MarshallingType.LIST, SimpleTypeJsonMarshallers.LIST).payloadMarshaller(MarshallingType.MAP, SimpleTypeJsonMarshallers.MAP).payloadMarshaller(MarshallingType.NULL, SimpleTypeJsonMarshallers.NULL).headerMarshaller(MarshallingType.STRING, HeaderMarshallers.STRING).headerMarshaller(MarshallingType.INTEGER, HeaderMarshallers.INTEGER).headerMarshaller(MarshallingType.LONG, HeaderMarshallers.LONG).headerMarshaller(MarshallingType.DOUBLE, HeaderMarshallers.DOUBLE).headerMarshaller(MarshallingType.FLOAT, HeaderMarshallers.FLOAT).headerMarshaller(MarshallingType.BOOLEAN, HeaderMarshallers.BOOLEAN).headerMarshaller(MarshallingType.INSTANT, HeaderMarshallers.INSTANT).headerMarshaller(MarshallingType.NULL, JsonMarshaller.NULL).queryParamMarshaller(MarshallingType.STRING, QueryParamMarshallers.STRING).queryParamMarshaller(MarshallingType.INTEGER, QueryParamMarshallers.INTEGER).queryParamMarshaller(MarshallingType.LONG, QueryParamMarshallers.LONG).queryParamMarshaller(MarshallingType.DOUBLE, QueryParamMarshallers.DOUBLE).queryParamMarshaller(MarshallingType.FLOAT, QueryParamMarshallers.FLOAT).queryParamMarshaller(MarshallingType.BOOLEAN, QueryParamMarshallers.BOOLEAN).queryParamMarshaller(MarshallingType.INSTANT, QueryParamMarshallers.INSTANT).queryParamMarshaller(MarshallingType.LIST, QueryParamMarshallers.LIST).queryParamMarshaller(MarshallingType.MAP, QueryParamMarshallers.MAP).queryParamMarshaller(MarshallingType.NULL, JsonMarshaller.NULL).pathParamMarshaller(MarshallingType.STRING, SimpleTypePathMarshallers.STRING).pathParamMarshaller(MarshallingType.INTEGER, SimpleTypePathMarshallers.INTEGER).pathParamMarshaller(MarshallingType.LONG, SimpleTypePathMarshallers.LONG).pathParamMarshaller(MarshallingType.NULL, SimpleTypePathMarshallers.NULL).greedyPathParamMarshaller(MarshallingType.STRING, SimpleTypePathMarshallers.GREEDY_STRING).greedyPathParamMarshaller(MarshallingType.NULL, SimpleTypePathMarshallers.NULL).build();
    }

    @Override
    public void startMarshalling() {
        if (!this.hasExplicitPayloadMember) {
            this.jsonGenerator.writeStartObject();
        }
    }

    public <V> void marshall(V val, MarshallingInfo<V> marshallingInfo) {
        this.doMarshall(this.resolveValue(val, marshallingInfo), marshallingInfo);
    }

    private <V> V resolveValue(V val, MarshallingInfo<V> marshallingInfo) {
        return val == null && marshallingInfo.defaultValueSupplier() != null ? marshallingInfo.defaultValueSupplier().get() : val;
    }

    private <V> void doMarshall(V val, MarshallingInfo<V> marshallingInfo) {
        if (marshallingInfo.isBinary()) {
            this.marshallBinaryPayload(val);
        } else {
            MARSHALLER_REGISTRY.getMarshaller(marshallingInfo.marshallLocation(), marshallingInfo.marshallingType(), val).marshall(val, this.marshallerContext, marshallingInfo.marshallLocationName());
        }
    }

    private void marshallBinaryPayload(Object val) {
        if (val instanceof ByteBuffer) {
            this.request.setContent(BinaryUtils.toStream((ByteBuffer)((ByteBuffer)val)));
        } else if (val instanceof InputStream) {
            this.request.setContent((InputStream)val);
        }
    }

    @Override
    public Request<OrigRequestT> finishMarshalling() {
        if (this.request.getContent() == null) {
            if (!this.hasExplicitPayloadMember) {
                this.jsonGenerator.writeEndObject();
            }
            byte[] content = this.jsonGenerator.getBytes();
            this.request.setContent(new ByteArrayInputStream(content));
            if (content.length > 0) {
                this.request.addHeader("Content-Length", Integer.toString(content.length));
            }
        }
        if (!this.request.getHeaders().containsKey("Content-Type")) {
            this.request.addHeader("Content-Type", this.contentType);
        }
        return this.request;
    }
}

