/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

@SdkProtectedApi
public abstract class AbstractErrorUnmarshaller<T>
implements Unmarshaller<AmazonServiceException, T> {
    protected final Class<? extends AmazonServiceException> exceptionClass;

    public AbstractErrorUnmarshaller() {
        this(AmazonServiceException.class);
    }

    public AbstractErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    protected AmazonServiceException newException(String message) throws Exception {
        Method builderMethod = null;
        try {
            builderMethod = this.exceptionClass.getDeclaredMethod("builder", new Class[0]);
            builderMethod.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (builderMethod != null) {
            Object exceptionBuilder = builderMethod.invoke(null, new Object[0]);
            Method buildMethod = exceptionBuilder.getClass().getDeclaredMethod("build", new Class[0]);
            Method messageSetter = exceptionBuilder.getClass().getDeclaredMethod("message", String.class);
            messageSetter.setAccessible(true);
            buildMethod.setAccessible(true);
            messageSetter.invoke(exceptionBuilder, message);
            return (AmazonServiceException)buildMethod.invoke(exceptionBuilder, new Object[0]);
        }
        Constructor<? extends AmazonServiceException> constructor = this.exceptionClass.getConstructor(String.class);
        return constructor.newInstance(message);
    }
}

