/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.sync;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Validate;

public class RequestBody {
    private final InputStream inputStream;
    private final long contentLength;

    private RequestBody(InputStream inputStream, long contentLength) {
        this.inputStream = (InputStream)Validate.paramNotNull((Object)inputStream, (String)"contents");
        this.contentLength = contentLength;
        Validate.validState((contentLength >= 0L ? 1 : 0) != 0, (String)"Content length must be greater than or equal to zero", (Object[])new Object[0]);
    }

    public InputStream asStream() {
        return this.inputStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public static RequestBody of(Path path) {
        return RequestBody.of(path.toFile());
    }

    public static RequestBody of(File file) {
        return new RequestBody((InputStream)FunctionalUtils.invokeSafely(() -> new FileInputStream(file)), file.length());
    }

    public static RequestBody of(InputStream inputStream, long contentLength) {
        return new RequestBody(inputStream, contentLength);
    }

    public static RequestBody of(String contents) {
        return new RequestBody((InputStream)FunctionalUtils.invokeSafely(() -> new StringInputStream(contents)), contents.length());
    }

    public static RequestBody of(byte[] bytes) {
        return RequestBody.ofByteDirect(Arrays.copyOf(bytes, bytes.length));
    }

    public static RequestBody of(ByteBuffer byteBuffer) {
        return RequestBody.ofByteDirect(BinaryUtils.copyAllBytesFrom((ByteBuffer)byteBuffer));
    }

    public static RequestBody empty() {
        return RequestBody.ofByteDirect(new byte[0]);
    }

    private static RequestBody ofByteDirect(byte[] bytes) {
        return new RequestBody(new ByteArrayInputStream(bytes), bytes.length);
    }
}

