/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.util;

import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.util.ClassLoaderHelper;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.JavaSystemSetting;

@ThreadSafe
public class VersionInfoUtils {
    static final String VERSION_INFO_FILE = "/software/amazon/awssdk/sdk/versionInfo.properties";
    private static final String UA_STRING = "aws-sdk-{platform}/{version} {os.name}/{os.version} {java.vm.name}/{java.vm.version}/{java.version}{language.and.region}{additional.languages}";
    private static final Logger log = LoggerFactory.getLogger(VersionInfoUtils.class);
    private static final String UNKNOWN = "unknown";
    private static volatile String version;
    private static volatile String platform;
    private static volatile String userAgent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (version != null) return version;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (version != null) return version;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPlatform() {
        if (platform != null) return platform;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (platform != null) return platform;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent() {
        if (userAgent != null) return userAgent;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (userAgent != null) return userAgent;
            VersionInfoUtils.initializeUserAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userAgent;
        }
    }

    private static void initializeVersion() {
        InputStream inputStream = ClassLoaderHelper.getResourceAsStream(VERSION_INFO_FILE, true, VersionInfoUtils.class);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new Exception("/software/amazon/awssdk/sdk/versionInfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
            platform = versionInfoProperties.getProperty("platform");
        }
        catch (Exception e) {
            log.info("Unable to load version information for the running SDK: " + e.getMessage());
            version = "unknown-version";
            platform = "java";
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)inputStream, (Logger)log);
        }
    }

    private static void initializeUserAgent() {
        userAgent = VersionInfoUtils.userAgent();
    }

    static String userAgent() {
        String ua = UA_STRING;
        ua = ua.replace("{platform}", StringUtils.lowerCase(VersionInfoUtils.getPlatform())).replace("{version}", VersionInfoUtils.getVersion()).replace("{os.name}", VersionInfoUtils.replaceSpaces(JavaSystemSetting.OS_NAME.getStringValue().orElse(null))).replace("{os.version}", VersionInfoUtils.replaceSpaces(JavaSystemSetting.OS_VERSION.getStringValue().orElse(null))).replace("{java.vm.name}", VersionInfoUtils.replaceSpaces(JavaSystemSetting.JAVA_VM_NAME.getStringValue().orElse(null))).replace("{java.vm.version}", VersionInfoUtils.replaceSpaces(JavaSystemSetting.JAVA_VM_VERSION.getStringValue().orElse(null))).replace("{java.version}", VersionInfoUtils.replaceSpaces(JavaSystemSetting.JAVA_VERSION.getStringValue().orElse(null))).replace("{additional.languages}", VersionInfoUtils.getAdditionalJvmLanguages());
        Optional language = JavaSystemSetting.USER_LANGUAGE.getStringValue();
        Optional region = JavaSystemSetting.USER_REGION.getStringValue();
        String languageAndRegion = "";
        if (language.isPresent() && region.isPresent()) {
            languageAndRegion = " " + VersionInfoUtils.replaceSpaces((String)language.get()) + "_" + VersionInfoUtils.replaceSpaces((String)region.get());
        }
        ua = ua.replace("{language.and.region}", languageAndRegion);
        return ua;
    }

    private static String replaceSpaces(String input) {
        return input == null ? UNKNOWN : input.replace(' ', '_');
    }

    private static String getAdditionalJvmLanguages() {
        return VersionInfoUtils.concat(VersionInfoUtils.concat("", VersionInfoUtils.scalaVersion(), " "), VersionInfoUtils.kotlinVersion(), " ");
    }

    private static String scalaVersion() {
        String scalaVersion;
        block3: {
            scalaVersion = "";
            try {
                Class<?> scalaProperties = Class.forName("scala.util.Properties");
                scalaVersion = "scala";
                String version = (String)scalaProperties.getMethod("versionNumberString", new Class[0]).invoke(null, new Object[0]);
                scalaVersion = VersionInfoUtils.concat(scalaVersion, version, "/");
            }
            catch (ClassNotFoundException scalaProperties) {
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Exception attempting to get Scala version.", (Throwable)e);
            }
        }
        return scalaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String kotlinVersion() {
        String kotlinVersion = "";
        JarInputStream kotlinJar = null;
        try {
            Class<?> kotlinUnit = Class.forName("kotlin.Unit");
            kotlinVersion = "kotlin";
            kotlinJar = new JarInputStream(kotlinUnit.getProtectionDomain().getCodeSource().getLocation().openStream());
            String version = kotlinJar.getManifest().getMainAttributes().getValue("Implementation-Version");
            kotlinVersion = VersionInfoUtils.concat(kotlinVersion, version, "/");
            IoUtils.closeQuietly((AutoCloseable)kotlinJar, (Logger)log);
        }
        catch (ClassNotFoundException kotlinUnit) {
            IoUtils.closeQuietly(kotlinJar, (Logger)log);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception attempting to get Kotlin version.", (Throwable)e);
            }
        }
        finally {
            IoUtils.closeQuietly(kotlinJar, (Logger)log);
        }
        return kotlinVersion;
    }

    private static String concat(String prefix, String suffix, String separator) {
        return suffix != null && !suffix.isEmpty() ? prefix + separator + suffix : prefix;
    }
}

