/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.waiters;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.util.ValidationUtils;
import software.amazon.awssdk.waiters.CompositeAcceptor;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.PollingStrategyContext;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.WaiterExecutionBuilder;
import software.amazon.awssdk.waiters.WaiterState;
import software.amazon.awssdk.waiters.WaiterTimedOutException;
import software.amazon.awssdk.waiters.WaiterUnrecoverableException;

@SdkProtectedApi
public class WaiterExecution<InputT extends AmazonWebServiceRequest, OutputT> {
    private final SdkFunction<InputT, OutputT> sdkFunction;
    private final InputT request;
    private final CompositeAcceptor<OutputT> acceptor;
    private final PollingStrategy pollingStrategy;

    public WaiterExecution(WaiterExecutionBuilder<InputT, OutputT> waiterExecutionBuilder) {
        this.sdkFunction = ValidationUtils.assertNotNull(waiterExecutionBuilder.getSdkFunction(), "sdkFunction");
        this.request = (AmazonWebServiceRequest)ValidationUtils.assertNotNull(waiterExecutionBuilder.getRequest(), "request");
        this.acceptor = new CompositeAcceptor<OutputT>(ValidationUtils.assertNotNull(waiterExecutionBuilder.getAcceptorsList(), "acceptors"));
        this.pollingStrategy = ValidationUtils.assertNotNull(waiterExecutionBuilder.getPollingStrategy(), "pollingStrategy");
    }

    public boolean pollResource() throws AmazonServiceException, WaiterTimedOutException, WaiterUnrecoverableException {
        int retriesAttempted = 0;
        block5: while (true) {
            switch (this.getCurrentState()) {
                case SUCCESS: {
                    return true;
                }
                case FAILURE: {
                    throw new WaiterUnrecoverableException("Resource never entered the desired state as it failed.");
                }
                case RETRY: {
                    PollingStrategyContext pollingStrategyContext = new PollingStrategyContext((AmazonWebServiceRequest)this.request, retriesAttempted);
                    if (this.pollingStrategy.getRetryStrategy().shouldRetry(pollingStrategyContext)) {
                        this.safeCustomDelay(pollingStrategyContext);
                        ++retriesAttempted;
                        continue block5;
                    }
                    throw new WaiterTimedOutException("Reached maximum attempts without transitioning to the desired state");
                }
            }
        }
    }

    private WaiterState getCurrentState() throws AmazonServiceException {
        try {
            return this.acceptor.accepts(this.sdkFunction.apply(this.request));
        }
        catch (AmazonServiceException amazonServiceException) {
            return this.acceptor.accepts(amazonServiceException);
        }
    }

    private void safeCustomDelay(PollingStrategyContext pollingStrategyContext) {
        try {
            this.pollingStrategy.getDelayStrategy().delayBeforeNextRetry(pollingStrategyContext);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

