/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileError;
import software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileErrorListCopier;
import software.amazon.awssdk.services.customerprofiles.model.CalculatedAttributeValue;
import software.amazon.awssdk.services.customerprofiles.model.CalculatedAttributeValueListCopier;
import software.amazon.awssdk.services.customerprofiles.model.ConditionOverrides;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCalculatedAttributeForProfileResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, BatchGetCalculatedAttributeForProfileResponse> {
    private static final SdkField<List<BatchGetCalculatedAttributeForProfileError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetCalculatedAttributeForProfileResponse.getter(BatchGetCalculatedAttributeForProfileResponse::errors)).setter(BatchGetCalculatedAttributeForProfileResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetCalculatedAttributeForProfileError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CalculatedAttributeValue>> CALCULATED_ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CalculatedAttributeValues").getter(BatchGetCalculatedAttributeForProfileResponse.getter(BatchGetCalculatedAttributeForProfileResponse::calculatedAttributeValues)).setter(BatchGetCalculatedAttributeForProfileResponse.setter(Builder::calculatedAttributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedAttributeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CalculatedAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConditionOverrides> CONDITION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConditionOverrides").getter(BatchGetCalculatedAttributeForProfileResponse.getter(BatchGetCalculatedAttributeForProfileResponse::conditionOverrides)).setter(BatchGetCalculatedAttributeForProfileResponse.setter(Builder::conditionOverrides)).constructor(ConditionOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionOverrides").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, CALCULATED_ATTRIBUTE_VALUES_FIELD, CONDITION_OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Errors", ERRORS_FIELD);
            this.put("CalculatedAttributeValues", CALCULATED_ATTRIBUTE_VALUES_FIELD);
            this.put("ConditionOverrides", CONDITION_OVERRIDES_FIELD);
        }
    });
    private final List<BatchGetCalculatedAttributeForProfileError> errors;
    private final List<CalculatedAttributeValue> calculatedAttributeValues;
    private final ConditionOverrides conditionOverrides;

    private BatchGetCalculatedAttributeForProfileResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.calculatedAttributeValues = builder.calculatedAttributeValues;
        this.conditionOverrides = builder.conditionOverrides;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetCalculatedAttributeForProfileError> errors() {
        return this.errors;
    }

    public final boolean hasCalculatedAttributeValues() {
        return this.calculatedAttributeValues != null && !(this.calculatedAttributeValues instanceof SdkAutoConstructList);
    }

    public final List<CalculatedAttributeValue> calculatedAttributeValues() {
        return this.calculatedAttributeValues;
    }

    public final ConditionOverrides conditionOverrides() {
        return this.conditionOverrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalculatedAttributeValues() ? this.calculatedAttributeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionOverrides());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCalculatedAttributeForProfileResponse)) {
            return false;
        }
        BatchGetCalculatedAttributeForProfileResponse other = (BatchGetCalculatedAttributeForProfileResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasCalculatedAttributeValues() == other.hasCalculatedAttributeValues() && Objects.equals(this.calculatedAttributeValues(), other.calculatedAttributeValues()) && Objects.equals(this.conditionOverrides(), other.conditionOverrides());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCalculatedAttributeForProfileResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("CalculatedAttributeValues", this.hasCalculatedAttributeValues() ? this.calculatedAttributeValues() : null).add("ConditionOverrides", (Object)(this.conditionOverrides() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "CalculatedAttributeValues": {
                return Optional.ofNullable(clazz.cast(this.calculatedAttributeValues()));
            }
            case "ConditionOverrides": {
                return Optional.ofNullable(clazz.cast(this.conditionOverrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCalculatedAttributeForProfileResponse, T> g) {
        return obj -> g.apply((BatchGetCalculatedAttributeForProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private List<BatchGetCalculatedAttributeForProfileError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<CalculatedAttributeValue> calculatedAttributeValues = DefaultSdkAutoConstructList.getInstance();
        private ConditionOverrides conditionOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCalculatedAttributeForProfileResponse model) {
            super(model);
            this.errors(model.errors);
            this.calculatedAttributeValues(model.calculatedAttributeValues);
            this.conditionOverrides(model.conditionOverrides);
        }

        public final List<BatchGetCalculatedAttributeForProfileError.Builder> getErrors() {
            List<BatchGetCalculatedAttributeForProfileError.Builder> result = BatchGetCalculatedAttributeForProfileErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetCalculatedAttributeForProfileError.BuilderImpl> errors) {
            this.errors = BatchGetCalculatedAttributeForProfileErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetCalculatedAttributeForProfileError> errors) {
            this.errors = BatchGetCalculatedAttributeForProfileErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetCalculatedAttributeForProfileError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetCalculatedAttributeForProfileError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetCalculatedAttributeForProfileError)((BatchGetCalculatedAttributeForProfileError.Builder)BatchGetCalculatedAttributeForProfileError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CalculatedAttributeValue.Builder> getCalculatedAttributeValues() {
            List<CalculatedAttributeValue.Builder> result = CalculatedAttributeValueListCopier.copyToBuilder(this.calculatedAttributeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculatedAttributeValues(Collection<CalculatedAttributeValue.BuilderImpl> calculatedAttributeValues) {
            this.calculatedAttributeValues = CalculatedAttributeValueListCopier.copyFromBuilder(calculatedAttributeValues);
        }

        @Override
        public final Builder calculatedAttributeValues(Collection<CalculatedAttributeValue> calculatedAttributeValues) {
            this.calculatedAttributeValues = CalculatedAttributeValueListCopier.copy(calculatedAttributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedAttributeValues(CalculatedAttributeValue ... calculatedAttributeValues) {
            this.calculatedAttributeValues(Arrays.asList(calculatedAttributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedAttributeValues(Consumer<CalculatedAttributeValue.Builder> ... calculatedAttributeValues) {
            this.calculatedAttributeValues(Stream.of(calculatedAttributeValues).map(c -> (CalculatedAttributeValue)((CalculatedAttributeValue.Builder)CalculatedAttributeValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConditionOverrides.Builder getConditionOverrides() {
            return this.conditionOverrides != null ? this.conditionOverrides.toBuilder() : null;
        }

        public final void setConditionOverrides(ConditionOverrides.BuilderImpl conditionOverrides) {
            this.conditionOverrides = conditionOverrides != null ? conditionOverrides.build() : null;
        }

        @Override
        public final Builder conditionOverrides(ConditionOverrides conditionOverrides) {
            this.conditionOverrides = conditionOverrides;
            return this;
        }

        @Override
        public BatchGetCalculatedAttributeForProfileResponse build() {
            return new BatchGetCalculatedAttributeForProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCalculatedAttributeForProfileResponse> {
        public Builder errors(Collection<BatchGetCalculatedAttributeForProfileError> var1);

        public Builder errors(BatchGetCalculatedAttributeForProfileError ... var1);

        public Builder errors(Consumer<BatchGetCalculatedAttributeForProfileError.Builder> ... var1);

        public Builder calculatedAttributeValues(Collection<CalculatedAttributeValue> var1);

        public Builder calculatedAttributeValues(CalculatedAttributeValue ... var1);

        public Builder calculatedAttributeValues(Consumer<CalculatedAttributeValue.Builder> ... var1);

        public Builder conditionOverrides(ConditionOverrides var1);

        default public Builder conditionOverrides(Consumer<ConditionOverrides.Builder> conditionOverrides) {
            return this.conditionOverrides((ConditionOverrides)((ConditionOverrides.Builder)ConditionOverrides.builder().applyMutation(conditionOverrides)).build());
        }
    }
}

