/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.IntegrationConfig;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.services.customerprofiles.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIntegrationWorkflowRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, CreateIntegrationWorkflowRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateIntegrationWorkflowRequest.getter(CreateIntegrationWorkflowRequest::domainName)).setter(CreateIntegrationWorkflowRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowType").getter(CreateIntegrationWorkflowRequest.getter(CreateIntegrationWorkflowRequest::workflowTypeAsString)).setter(CreateIntegrationWorkflowRequest.setter(Builder::workflowType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowType").build()}).build();
    private static final SdkField<IntegrationConfig> INTEGRATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IntegrationConfig").getter(CreateIntegrationWorkflowRequest.getter(CreateIntegrationWorkflowRequest::integrationConfig)).setter(CreateIntegrationWorkflowRequest.setter(Builder::integrationConfig)).constructor(IntegrationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationConfig").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(CreateIntegrationWorkflowRequest.getter(CreateIntegrationWorkflowRequest::objectTypeName)).setter(CreateIntegrationWorkflowRequest.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateIntegrationWorkflowRequest.getter(CreateIntegrationWorkflowRequest::roleArn)).setter(CreateIntegrationWorkflowRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateIntegrationWorkflowRequest.getter(CreateIntegrationWorkflowRequest::tags)).setter(CreateIntegrationWorkflowRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, WORKFLOW_TYPE_FIELD, INTEGRATION_CONFIG_FIELD, OBJECT_TYPE_NAME_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("WorkflowType", WORKFLOW_TYPE_FIELD);
            this.put("IntegrationConfig", INTEGRATION_CONFIG_FIELD);
            this.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String domainName;
    private final String workflowType;
    private final IntegrationConfig integrationConfig;
    private final String objectTypeName;
    private final String roleArn;
    private final Map<String, String> tags;

    private CreateIntegrationWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.workflowType = builder.workflowType;
        this.integrationConfig = builder.integrationConfig;
        this.objectTypeName = builder.objectTypeName;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(this.workflowType);
    }

    public final String workflowTypeAsString() {
        return this.workflowType;
    }

    public final IntegrationConfig integrationConfig() {
        return this.integrationConfig;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationWorkflowRequest)) {
            return false;
        }
        CreateIntegrationWorkflowRequest other = (CreateIntegrationWorkflowRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.workflowTypeAsString(), other.workflowTypeAsString()) && Objects.equals(this.integrationConfig(), other.integrationConfig()) && Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIntegrationWorkflowRequest").add("DomainName", (Object)this.domainName()).add("WorkflowType", (Object)this.workflowTypeAsString()).add("IntegrationConfig", (Object)this.integrationConfig()).add("ObjectTypeName", (Object)this.objectTypeName()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "WorkflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowTypeAsString()));
            }
            case "IntegrationConfig": {
                return Optional.ofNullable(clazz.cast(this.integrationConfig()));
            }
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationWorkflowRequest, T> g) {
        return obj -> g.apply((CreateIntegrationWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String workflowType;
        private IntegrationConfig integrationConfig;
        private String objectTypeName;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationWorkflowRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.workflowType(model.workflowType);
            this.integrationConfig(model.integrationConfig);
            this.objectTypeName(model.objectTypeName);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getWorkflowType() {
            return this.workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final IntegrationConfig.Builder getIntegrationConfig() {
            return this.integrationConfig != null ? this.integrationConfig.toBuilder() : null;
        }

        public final void setIntegrationConfig(IntegrationConfig.BuilderImpl integrationConfig) {
            this.integrationConfig = integrationConfig != null ? integrationConfig.build() : null;
        }

        @Override
        public final Builder integrationConfig(IntegrationConfig integrationConfig) {
            this.integrationConfig = integrationConfig;
            return this;
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationWorkflowRequest build() {
            return new CreateIntegrationWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIntegrationWorkflowRequest> {
        public Builder domainName(String var1);

        public Builder workflowType(String var1);

        public Builder workflowType(WorkflowType var1);

        public Builder integrationConfig(IntegrationConfig var1);

        default public Builder integrationConfig(Consumer<IntegrationConfig.Builder> integrationConfig) {
            return this.integrationConfig((IntegrationConfig)((IntegrationConfig.Builder)IntegrationConfig.builder().applyMutation(integrationConfig)).build());
        }

        public Builder objectTypeName(String var1);

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

