/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.DataFormat;
import software.amazon.awssdk.services.customerprofiles.model.SegmentSnapshotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSegmentSnapshotResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetSegmentSnapshotResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(GetSegmentSnapshotResponse.getter(GetSegmentSnapshotResponse::snapshotId)).setter(GetSegmentSnapshotResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetSegmentSnapshotResponse.getter(GetSegmentSnapshotResponse::statusAsString)).setter(GetSegmentSnapshotResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetSegmentSnapshotResponse.getter(GetSegmentSnapshotResponse::statusMessage)).setter(GetSegmentSnapshotResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(GetSegmentSnapshotResponse.getter(GetSegmentSnapshotResponse::dataFormatAsString)).setter(GetSegmentSnapshotResponse.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKey").getter(GetSegmentSnapshotResponse.getter(GetSegmentSnapshotResponse::encryptionKey)).setter(GetSegmentSnapshotResponse.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(GetSegmentSnapshotResponse.getter(GetSegmentSnapshotResponse::roleArn)).setter(GetSegmentSnapshotResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DESTINATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationUri").getter(GetSegmentSnapshotResponse.getter(GetSegmentSnapshotResponse::destinationUri)).setter(GetSegmentSnapshotResponse.setter(Builder::destinationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, DATA_FORMAT_FIELD, ENCRYPTION_KEY_FIELD, ROLE_ARN_FIELD, DESTINATION_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SnapshotId", SNAPSHOT_ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("DataFormat", DATA_FORMAT_FIELD);
            this.put("EncryptionKey", ENCRYPTION_KEY_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("DestinationUri", DESTINATION_URI_FIELD);
        }
    });
    private final String snapshotId;
    private final String status;
    private final String statusMessage;
    private final String dataFormat;
    private final String encryptionKey;
    private final String roleArn;
    private final String destinationUri;

    private GetSegmentSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.dataFormat = builder.dataFormat;
        this.encryptionKey = builder.encryptionKey;
        this.roleArn = builder.roleArn;
        this.destinationUri = builder.destinationUri;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final SegmentSnapshotStatus status() {
        return SegmentSnapshotStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final DataFormat dataFormat() {
        return DataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String destinationUri() {
        return this.destinationUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentSnapshotResponse)) {
            return false;
        }
        GetSegmentSnapshotResponse other = (GetSegmentSnapshotResponse)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.destinationUri(), other.destinationUri());
    }

    public final String toString() {
        return ToString.builder((String)"GetSegmentSnapshotResponse").add("SnapshotId", (Object)this.snapshotId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("DataFormat", (Object)this.dataFormatAsString()).add("EncryptionKey", (Object)this.encryptionKey()).add("RoleArn", (Object)this.roleArn()).add("DestinationUri", (Object)this.destinationUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "EncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "DestinationUri": {
                return Optional.ofNullable(clazz.cast(this.destinationUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentSnapshotResponse, T> g) {
        return obj -> g.apply((GetSegmentSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String snapshotId;
        private String status;
        private String statusMessage;
        private String dataFormat;
        private String encryptionKey;
        private String roleArn;
        private String destinationUri;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentSnapshotResponse model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.dataFormat(model.dataFormat);
            this.encryptionKey(model.encryptionKey);
            this.roleArn(model.roleArn);
            this.destinationUri(model.destinationUri);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SegmentSnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDestinationUri() {
            return this.destinationUri;
        }

        public final void setDestinationUri(String destinationUri) {
            this.destinationUri = destinationUri;
        }

        @Override
        public final Builder destinationUri(String destinationUri) {
            this.destinationUri = destinationUri;
            return this;
        }

        @Override
        public GetSegmentSnapshotResponse build() {
            return new GetSegmentSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSegmentSnapshotResponse> {
        public Builder snapshotId(String var1);

        public Builder status(String var1);

        public Builder status(SegmentSnapshotStatus var1);

        public Builder statusMessage(String var1);

        public Builder dataFormat(String var1);

        public Builder dataFormat(DataFormat var1);

        public Builder encryptionKey(String var1);

        public Builder roleArn(String var1);

        public Builder destinationUri(String var1);
    }
}

