/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;
import software.amazon.awssdk.services.databasemigration.waiters.DatabaseMigrationAsyncWaiter;
import software.amazon.awssdk.services.databasemigration.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultDatabaseMigrationAsyncWaiter
implements DatabaseMigrationAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final DatabaseMigrationAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeConnectionsResponse> testConnectionSucceedsWaiter;
    private final AsyncWaiter<DescribeEndpointsResponse> endpointDeletedWaiter;
    private final AsyncWaiter<DescribeReplicationInstancesResponse> replicationInstanceAvailableWaiter;
    private final AsyncWaiter<DescribeReplicationInstancesResponse> replicationInstanceDeletedWaiter;
    private final AsyncWaiter<DescribeReplicationTasksResponse> replicationTaskReadyWaiter;
    private final AsyncWaiter<DescribeReplicationTasksResponse> replicationTaskStoppedWaiter;
    private final AsyncWaiter<DescribeReplicationTasksResponse> replicationTaskRunningWaiter;
    private final AsyncWaiter<DescribeReplicationTasksResponse> replicationTaskDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultDatabaseMigrationAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (DatabaseMigrationAsyncClient)DatabaseMigrationAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.testConnectionSucceedsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeConnectionsResponse.class).acceptors(DefaultDatabaseMigrationAsyncWaiter.testConnectionSucceedsWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationAsyncWaiter.testConnectionSucceedsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.endpointDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeEndpointsResponse.class).acceptors(DefaultDatabaseMigrationAsyncWaiter.endpointDeletedWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationAsyncWaiter.endpointDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.replicationInstanceAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeReplicationInstancesResponse.class).acceptors(DefaultDatabaseMigrationAsyncWaiter.replicationInstanceAvailableWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationAsyncWaiter.replicationInstanceAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.replicationInstanceDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeReplicationInstancesResponse.class).acceptors(DefaultDatabaseMigrationAsyncWaiter.replicationInstanceDeletedWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationAsyncWaiter.replicationInstanceDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.replicationTaskReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeReplicationTasksResponse.class).acceptors(DefaultDatabaseMigrationAsyncWaiter.replicationTaskReadyWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationAsyncWaiter.replicationTaskReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.replicationTaskStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeReplicationTasksResponse.class).acceptors(DefaultDatabaseMigrationAsyncWaiter.replicationTaskStoppedWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationAsyncWaiter.replicationTaskStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.replicationTaskRunningWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeReplicationTasksResponse.class).acceptors(DefaultDatabaseMigrationAsyncWaiter.replicationTaskRunningWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationAsyncWaiter.replicationTaskRunningWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.replicationTaskDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeReplicationTasksResponse.class).acceptors(DefaultDatabaseMigrationAsyncWaiter.replicationTaskDeletedWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationAsyncWaiter.replicationTaskDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEndpointsResponse>> waitUntilEndpointDeleted(DescribeEndpointsRequest describeEndpointsRequest) {
        return this.endpointDeletedWaiter.runAsync(() -> this.client.describeEndpoints(this.applyWaitersUserAgent(describeEndpointsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEndpointsResponse>> waitUntilEndpointDeleted(DescribeEndpointsRequest describeEndpointsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.endpointDeletedWaiter.runAsync(() -> this.client.describeEndpoints(this.applyWaitersUserAgent(describeEndpointsRequest)), DefaultDatabaseMigrationAsyncWaiter.endpointDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationInstancesResponse>> waitUntilReplicationInstanceAvailable(DescribeReplicationInstancesRequest describeReplicationInstancesRequest) {
        return this.replicationInstanceAvailableWaiter.runAsync(() -> this.client.describeReplicationInstances(this.applyWaitersUserAgent(describeReplicationInstancesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationInstancesResponse>> waitUntilReplicationInstanceAvailable(DescribeReplicationInstancesRequest describeReplicationInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationInstanceAvailableWaiter.runAsync(() -> this.client.describeReplicationInstances(this.applyWaitersUserAgent(describeReplicationInstancesRequest)), DefaultDatabaseMigrationAsyncWaiter.replicationInstanceAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationInstancesResponse>> waitUntilReplicationInstanceDeleted(DescribeReplicationInstancesRequest describeReplicationInstancesRequest) {
        return this.replicationInstanceDeletedWaiter.runAsync(() -> this.client.describeReplicationInstances(this.applyWaitersUserAgent(describeReplicationInstancesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationInstancesResponse>> waitUntilReplicationInstanceDeleted(DescribeReplicationInstancesRequest describeReplicationInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationInstanceDeletedWaiter.runAsync(() -> this.client.describeReplicationInstances(this.applyWaitersUserAgent(describeReplicationInstancesRequest)), DefaultDatabaseMigrationAsyncWaiter.replicationInstanceDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationTasksResponse>> waitUntilReplicationTaskDeleted(DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        return this.replicationTaskDeletedWaiter.runAsync(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationTasksResponse>> waitUntilReplicationTaskDeleted(DescribeReplicationTasksRequest describeReplicationTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationTaskDeletedWaiter.runAsync(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)), DefaultDatabaseMigrationAsyncWaiter.replicationTaskDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationTasksResponse>> waitUntilReplicationTaskReady(DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        return this.replicationTaskReadyWaiter.runAsync(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationTasksResponse>> waitUntilReplicationTaskReady(DescribeReplicationTasksRequest describeReplicationTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationTaskReadyWaiter.runAsync(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)), DefaultDatabaseMigrationAsyncWaiter.replicationTaskReadyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationTasksResponse>> waitUntilReplicationTaskRunning(DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        return this.replicationTaskRunningWaiter.runAsync(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationTasksResponse>> waitUntilReplicationTaskRunning(DescribeReplicationTasksRequest describeReplicationTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationTaskRunningWaiter.runAsync(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)), DefaultDatabaseMigrationAsyncWaiter.replicationTaskRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationTasksResponse>> waitUntilReplicationTaskStopped(DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        return this.replicationTaskStoppedWaiter.runAsync(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeReplicationTasksResponse>> waitUntilReplicationTaskStopped(DescribeReplicationTasksRequest describeReplicationTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationTaskStoppedWaiter.runAsync(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)), DefaultDatabaseMigrationAsyncWaiter.replicationTaskStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeConnectionsResponse>> waitUntilTestConnectionSucceeds(DescribeConnectionsRequest describeConnectionsRequest) {
        return this.testConnectionSucceedsWaiter.runAsync(() -> this.client.describeConnections(this.applyWaitersUserAgent(describeConnectionsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeConnectionsResponse>> waitUntilTestConnectionSucceeds(DescribeConnectionsRequest describeConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.testConnectionSucceedsWaiter.runAsync(() -> this.client.describeConnections(this.applyWaitersUserAgent(describeConnectionsRequest)), DefaultDatabaseMigrationAsyncWaiter.testConnectionSucceedsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeConnectionsResponse>> testConnectionSucceedsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeConnectionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Connections").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "successful"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Connections").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Connections[].Status=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEndpointsResponse>> endpointDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEndpointsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEndpointsResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDatabaseMigrationAsyncWaiter.errorCode(error), "ResourceNotFoundFault")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Endpoints").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "active"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Endpoints[].Status=active) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Endpoints").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Endpoints[].Status=creating) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationInstancesResponse>> replicationInstanceAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-credentials"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=incompatible-credentials) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-network"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=incompatible-network) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "inaccessible-encryption-credentials"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=inaccessible-encryption-credentials) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationInstancesResponse>> replicationInstanceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationInstancesResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "available"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=available) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDatabaseMigrationAsyncWaiter.errorCode(error), "ResourceNotFoundFault")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationTasksResponse>> replicationTaskReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "ready"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "starting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=starting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "running"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=running) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopping) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopped"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopped) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=modifying) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "testing"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=testing) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationTasksResponse>> replicationTaskStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "stopped"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ready"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=ready) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=creating) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "starting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=starting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=modifying) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "testing"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=testing) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationTasksResponse>> replicationTaskRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "running"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ready"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=ready) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=creating) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopping) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopped"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopped) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=modifying) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "testing"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=testing) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationTasksResponse>> replicationTaskDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ready"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=ready) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=creating) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopped"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopped) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "running"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=running) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDatabaseMigrationAsyncWaiter.errorCode(error), "ResourceNotFoundFault")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration testConnectionSucceedsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration endpointDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationInstanceAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationInstanceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationTaskReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationTaskStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationTaskRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationTaskDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static DatabaseMigrationAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends DatabaseMigrationRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DatabaseMigrationRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements DatabaseMigrationAsyncWaiter.Builder {
        private DatabaseMigrationAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public DatabaseMigrationAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public DatabaseMigrationAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public DatabaseMigrationAsyncWaiter.Builder client(DatabaseMigrationAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public DatabaseMigrationAsyncWaiter build() {
            return new DefaultDatabaseMigrationAsyncWaiter(this);
        }
    }
}

