/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.OriginTypeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMetadataModelImportRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, StartMetadataModelImportRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectIdentifier").getter(StartMetadataModelImportRequest.getter(StartMetadataModelImportRequest::migrationProjectIdentifier)).setter(StartMetadataModelImportRequest.setter(Builder::migrationProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build()}).build();
    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionRules").getter(StartMetadataModelImportRequest.getter(StartMetadataModelImportRequest::selectionRules)).setter(StartMetadataModelImportRequest.setter(Builder::selectionRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Origin").getter(StartMetadataModelImportRequest.getter(StartMetadataModelImportRequest::originAsString)).setter(StartMetadataModelImportRequest.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()}).build();
    private static final SdkField<Boolean> REFRESH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Refresh").getter(StartMetadataModelImportRequest.getter(StartMetadataModelImportRequest::refresh)).setter(StartMetadataModelImportRequest.setter(Builder::refresh)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Refresh").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_IDENTIFIER_FIELD, SELECTION_RULES_FIELD, ORIGIN_FIELD, REFRESH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMetadataModelImportRequest.memberNameToFieldInitializer();
    private final String migrationProjectIdentifier;
    private final String selectionRules;
    private final String origin;
    private final Boolean refresh;

    private StartMetadataModelImportRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.selectionRules = builder.selectionRules;
        this.origin = builder.origin;
        this.refresh = builder.refresh;
    }

    public final String migrationProjectIdentifier() {
        return this.migrationProjectIdentifier;
    }

    public final String selectionRules() {
        return this.selectionRules;
    }

    public final OriginTypeValue origin() {
        return OriginTypeValue.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public final Boolean refresh() {
        return this.refresh;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.refresh());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMetadataModelImportRequest)) {
            return false;
        }
        StartMetadataModelImportRequest other = (StartMetadataModelImportRequest)((Object)obj);
        return Objects.equals(this.migrationProjectIdentifier(), other.migrationProjectIdentifier()) && Objects.equals(this.selectionRules(), other.selectionRules()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.refresh(), other.refresh());
    }

    public final String toString() {
        return ToString.builder((String)"StartMetadataModelImportRequest").add("MigrationProjectIdentifier", (Object)this.migrationProjectIdentifier()).add("SelectionRules", (Object)this.selectionRules()).add("Origin", (Object)this.originAsString()).add("Refresh", (Object)this.refresh()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MigrationProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectIdentifier()));
            }
            case "SelectionRules": {
                return Optional.ofNullable(clazz.cast(this.selectionRules()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "Refresh": {
                return Optional.ofNullable(clazz.cast(this.refresh()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MigrationProjectIdentifier", MIGRATION_PROJECT_IDENTIFIER_FIELD);
        map.put("SelectionRules", SELECTION_RULES_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("Refresh", REFRESH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMetadataModelImportRequest, T> g) {
        return obj -> g.apply((StartMetadataModelImportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String migrationProjectIdentifier;
        private String selectionRules;
        private String origin;
        private Boolean refresh;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMetadataModelImportRequest model) {
            super(model);
            this.migrationProjectIdentifier(model.migrationProjectIdentifier);
            this.selectionRules(model.selectionRules);
            this.origin(model.origin);
            this.refresh(model.refresh);
        }

        public final String getMigrationProjectIdentifier() {
            return this.migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getSelectionRules() {
            return this.selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginTypeValue origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final Boolean getRefresh() {
            return this.refresh;
        }

        public final void setRefresh(Boolean refresh) {
            this.refresh = refresh;
        }

        @Override
        public final Builder refresh(Boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMetadataModelImportRequest build() {
            return new StartMetadataModelImportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMetadataModelImportRequest> {
        public Builder migrationProjectIdentifier(String var1);

        public Builder selectionRules(String var1);

        public Builder origin(String var1);

        public Builder origin(OriginTypeValue var1);

        public Builder refresh(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

