/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.JobLifecycleStatus;
import software.amazon.awssdk.services.deadline.model.JobParameter;
import software.amazon.awssdk.services.deadline.model.JobParametersCopier;
import software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskRunStatusCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobSearchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobSearchSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(JobSearchSummary.getter(JobSearchSummary::jobId)).setter(JobSearchSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(JobSearchSummary.getter(JobSearchSummary::queueId)).setter(JobSearchSummary.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(JobSearchSummary.getter(JobSearchSummary::name)).setter(JobSearchSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatus").getter(JobSearchSummary.getter(JobSearchSummary::lifecycleStatusAsString)).setter(JobSearchSummary.setter(Builder::lifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatusMessage").getter(JobSearchSummary.getter(JobSearchSummary::lifecycleStatusMessage)).setter(JobSearchSummary.setter(Builder::lifecycleStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatusMessage").build()}).build();
    private static final SdkField<String> TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskRunStatus").getter(JobSearchSummary.getter(JobSearchSummary::taskRunStatusAsString)).setter(JobSearchSummary.setter(Builder::taskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatus").build()}).build();
    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetTaskRunStatus").getter(JobSearchSummary.getter(JobSearchSummary::targetTaskRunStatusAsString)).setter(JobSearchSummary.setter(Builder::targetTaskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build()}).build();
    private static final SdkField<Map<String, Integer>> TASK_RUN_STATUS_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("taskRunStatusCounts").getter(JobSearchSummary.getter(JobSearchSummary::taskRunStatusCountsAsStrings)).setter(JobSearchSummary.setter(Builder::taskRunStatusCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatusCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(JobSearchSummary.getter(JobSearchSummary::priority)).setter(JobSearchSummary.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<Integer> MAX_FAILED_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxFailedTasksCount").getter(JobSearchSummary.getter(JobSearchSummary::maxFailedTasksCount)).setter(JobSearchSummary.setter(Builder::maxFailedTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailedTasksCount").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_PER_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxRetriesPerTask").getter(JobSearchSummary.getter(JobSearchSummary::maxRetriesPerTask)).setter(JobSearchSummary.setter(Builder::maxRetriesPerTask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetriesPerTask").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(JobSearchSummary.getter(JobSearchSummary::createdBy)).setter(JobSearchSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(JobSearchSummary.getter(JobSearchSummary::createdAt)).setter(JobSearchSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(JobSearchSummary.getter(JobSearchSummary::endedAt)).setter(JobSearchSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(JobSearchSummary.getter(JobSearchSummary::startedAt)).setter(JobSearchSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, JobParameter>> JOB_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("jobParameters").getter(JobSearchSummary.getter(JobSearchSummary::jobParameters)).setter(JobSearchSummary.setter(Builder::jobParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceJobId").getter(JobSearchSummary.getter(JobSearchSummary::sourceJobId)).setter(JobSearchSummary.setter(Builder::sourceJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceJobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, QUEUE_ID_FIELD, NAME_FIELD, LIFECYCLE_STATUS_FIELD, LIFECYCLE_STATUS_MESSAGE_FIELD, TASK_RUN_STATUS_FIELD, TARGET_TASK_RUN_STATUS_FIELD, TASK_RUN_STATUS_COUNTS_FIELD, PRIORITY_FIELD, MAX_FAILED_TASKS_COUNT_FIELD, MAX_RETRIES_PER_TASK_FIELD, CREATED_BY_FIELD, CREATED_AT_FIELD, ENDED_AT_FIELD, STARTED_AT_FIELD, JOB_PARAMETERS_FIELD, SOURCE_JOB_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jobId", JOB_ID_FIELD);
            this.put("queueId", QUEUE_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
            this.put("lifecycleStatusMessage", LIFECYCLE_STATUS_MESSAGE_FIELD);
            this.put("taskRunStatus", TASK_RUN_STATUS_FIELD);
            this.put("targetTaskRunStatus", TARGET_TASK_RUN_STATUS_FIELD);
            this.put("taskRunStatusCounts", TASK_RUN_STATUS_COUNTS_FIELD);
            this.put("priority", PRIORITY_FIELD);
            this.put("maxFailedTasksCount", MAX_FAILED_TASKS_COUNT_FIELD);
            this.put("maxRetriesPerTask", MAX_RETRIES_PER_TASK_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("endedAt", ENDED_AT_FIELD);
            this.put("startedAt", STARTED_AT_FIELD);
            this.put("jobParameters", JOB_PARAMETERS_FIELD);
            this.put("sourceJobId", SOURCE_JOB_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String queueId;
    private final String name;
    private final String lifecycleStatus;
    private final String lifecycleStatusMessage;
    private final String taskRunStatus;
    private final String targetTaskRunStatus;
    private final Map<String, Integer> taskRunStatusCounts;
    private final Integer priority;
    private final Integer maxFailedTasksCount;
    private final Integer maxRetriesPerTask;
    private final String createdBy;
    private final Instant createdAt;
    private final Instant endedAt;
    private final Instant startedAt;
    private final Map<String, JobParameter> jobParameters;
    private final String sourceJobId;

    private JobSearchSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.queueId = builder.queueId;
        this.name = builder.name;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.lifecycleStatusMessage = builder.lifecycleStatusMessage;
        this.taskRunStatus = builder.taskRunStatus;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.taskRunStatusCounts = builder.taskRunStatusCounts;
        this.priority = builder.priority;
        this.maxFailedTasksCount = builder.maxFailedTasksCount;
        this.maxRetriesPerTask = builder.maxRetriesPerTask;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.endedAt = builder.endedAt;
        this.startedAt = builder.startedAt;
        this.jobParameters = builder.jobParameters;
        this.sourceJobId = builder.sourceJobId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String name() {
        return this.name;
    }

    public final JobLifecycleStatus lifecycleStatus() {
        return JobLifecycleStatus.fromValue(this.lifecycleStatus);
    }

    public final String lifecycleStatusAsString() {
        return this.lifecycleStatus;
    }

    public final String lifecycleStatusMessage() {
        return this.lifecycleStatusMessage;
    }

    public final TaskRunStatus taskRunStatus() {
        return TaskRunStatus.fromValue(this.taskRunStatus);
    }

    public final String taskRunStatusAsString() {
        return this.taskRunStatus;
    }

    public final JobTargetTaskRunStatus targetTaskRunStatus() {
        return JobTargetTaskRunStatus.fromValue(this.targetTaskRunStatus);
    }

    public final String targetTaskRunStatusAsString() {
        return this.targetTaskRunStatus;
    }

    public final Map<TaskRunStatus, Integer> taskRunStatusCounts() {
        return TaskRunStatusCountsCopier.copyStringToEnum(this.taskRunStatusCounts);
    }

    public final boolean hasTaskRunStatusCounts() {
        return this.taskRunStatusCounts != null && !(this.taskRunStatusCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> taskRunStatusCountsAsStrings() {
        return this.taskRunStatusCounts;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Integer maxFailedTasksCount() {
        return this.maxFailedTasksCount;
    }

    public final Integer maxRetriesPerTask() {
        return this.maxRetriesPerTask;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final boolean hasJobParameters() {
        return this.jobParameters != null && !(this.jobParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, JobParameter> jobParameters() {
        return this.jobParameters;
    }

    public final String sourceJobId() {
        return this.sourceJobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskRunStatusCounts() ? this.taskRunStatusCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFailedTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetriesPerTask());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobParameters() ? this.jobParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceJobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSearchSummary)) {
            return false;
        }
        JobSearchSummary other = (JobSearchSummary)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.lifecycleStatusAsString(), other.lifecycleStatusAsString()) && Objects.equals(this.lifecycleStatusMessage(), other.lifecycleStatusMessage()) && Objects.equals(this.taskRunStatusAsString(), other.taskRunStatusAsString()) && Objects.equals(this.targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString()) && this.hasTaskRunStatusCounts() == other.hasTaskRunStatusCounts() && Objects.equals(this.taskRunStatusCountsAsStrings(), other.taskRunStatusCountsAsStrings()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.maxFailedTasksCount(), other.maxFailedTasksCount()) && Objects.equals(this.maxRetriesPerTask(), other.maxRetriesPerTask()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && this.hasJobParameters() == other.hasJobParameters() && Objects.equals(this.jobParameters(), other.jobParameters()) && Objects.equals(this.sourceJobId(), other.sourceJobId());
    }

    public final String toString() {
        return ToString.builder((String)"JobSearchSummary").add("JobId", (Object)this.jobId()).add("QueueId", (Object)this.queueId()).add("Name", (Object)this.name()).add("LifecycleStatus", (Object)this.lifecycleStatusAsString()).add("LifecycleStatusMessage", (Object)this.lifecycleStatusMessage()).add("TaskRunStatus", (Object)this.taskRunStatusAsString()).add("TargetTaskRunStatus", (Object)this.targetTaskRunStatusAsString()).add("TaskRunStatusCounts", this.hasTaskRunStatusCounts() ? this.taskRunStatusCountsAsStrings() : null).add("Priority", (Object)this.priority()).add("MaxFailedTasksCount", (Object)this.maxFailedTasksCount()).add("MaxRetriesPerTask", (Object)this.maxRetriesPerTask()).add("CreatedBy", (Object)this.createdBy()).add("CreatedAt", (Object)this.createdAt()).add("EndedAt", (Object)this.endedAt()).add("StartedAt", (Object)this.startedAt()).add("JobParameters", (Object)(this.jobParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("SourceJobId", (Object)this.sourceJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "lifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusAsString()));
            }
            case "lifecycleStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusMessage()));
            }
            case "taskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.taskRunStatusAsString()));
            }
            case "targetTaskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.targetTaskRunStatusAsString()));
            }
            case "taskRunStatusCounts": {
                return Optional.ofNullable(clazz.cast(this.taskRunStatusCountsAsStrings()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "maxFailedTasksCount": {
                return Optional.ofNullable(clazz.cast(this.maxFailedTasksCount()));
            }
            case "maxRetriesPerTask": {
                return Optional.ofNullable(clazz.cast(this.maxRetriesPerTask()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "jobParameters": {
                return Optional.ofNullable(clazz.cast(this.jobParameters()));
            }
            case "sourceJobId": {
                return Optional.ofNullable(clazz.cast(this.sourceJobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JobSearchSummary, T> g) {
        return obj -> g.apply((JobSearchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String queueId;
        private String name;
        private String lifecycleStatus;
        private String lifecycleStatusMessage;
        private String taskRunStatus;
        private String targetTaskRunStatus;
        private Map<String, Integer> taskRunStatusCounts = DefaultSdkAutoConstructMap.getInstance();
        private Integer priority;
        private Integer maxFailedTasksCount;
        private Integer maxRetriesPerTask;
        private String createdBy;
        private Instant createdAt;
        private Instant endedAt;
        private Instant startedAt;
        private Map<String, JobParameter> jobParameters = DefaultSdkAutoConstructMap.getInstance();
        private String sourceJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSearchSummary model) {
            this.jobId(model.jobId);
            this.queueId(model.queueId);
            this.name(model.name);
            this.lifecycleStatus(model.lifecycleStatus);
            this.lifecycleStatusMessage(model.lifecycleStatusMessage);
            this.taskRunStatus(model.taskRunStatus);
            this.targetTaskRunStatus(model.targetTaskRunStatus);
            this.taskRunStatusCountsWithStrings(model.taskRunStatusCounts);
            this.priority(model.priority);
            this.maxFailedTasksCount(model.maxFailedTasksCount);
            this.maxRetriesPerTask(model.maxRetriesPerTask);
            this.createdBy(model.createdBy);
            this.createdAt(model.createdAt);
            this.endedAt(model.endedAt);
            this.startedAt(model.startedAt);
            this.jobParameters(model.jobParameters);
            this.sourceJobId(model.sourceJobId);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLifecycleStatus() {
            return this.lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(JobLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final String getLifecycleStatusMessage() {
            return this.lifecycleStatusMessage;
        }

        public final void setLifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
        }

        @Override
        public final Builder lifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
            return this;
        }

        public final String getTaskRunStatus() {
            return this.taskRunStatus;
        }

        public final void setTaskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
        }

        @Override
        public final Builder taskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
            return this;
        }

        @Override
        public final Builder taskRunStatus(TaskRunStatus taskRunStatus) {
            this.taskRunStatus(taskRunStatus == null ? null : taskRunStatus.toString());
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return this.targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(JobTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final Map<String, Integer> getTaskRunStatusCounts() {
            if (this.taskRunStatusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.taskRunStatusCounts;
        }

        public final void setTaskRunStatusCounts(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
        }

        @Override
        public final Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
            return this;
        }

        @Override
        public final Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copyEnumToString(taskRunStatusCounts);
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Integer getMaxFailedTasksCount() {
            return this.maxFailedTasksCount;
        }

        public final void setMaxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
        }

        @Override
        public final Builder maxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
            return this;
        }

        public final Integer getMaxRetriesPerTask() {
            return this.maxRetriesPerTask;
        }

        public final void setMaxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
        }

        @Override
        public final Builder maxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Map<String, JobParameter.Builder> getJobParameters() {
            Map<String, JobParameter.Builder> result = JobParametersCopier.copyToBuilder(this.jobParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setJobParameters(Map<String, JobParameter.BuilderImpl> jobParameters) {
            this.jobParameters = JobParametersCopier.copyFromBuilder(jobParameters);
        }

        @Override
        public final Builder jobParameters(Map<String, JobParameter> jobParameters) {
            this.jobParameters = JobParametersCopier.copy(jobParameters);
            return this;
        }

        public final String getSourceJobId() {
            return this.sourceJobId;
        }

        public final void setSourceJobId(String sourceJobId) {
            this.sourceJobId = sourceJobId;
        }

        @Override
        public final Builder sourceJobId(String sourceJobId) {
            this.sourceJobId = sourceJobId;
            return this;
        }

        public JobSearchSummary build() {
            return new JobSearchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobSearchSummary> {
        public Builder jobId(String var1);

        public Builder queueId(String var1);

        public Builder name(String var1);

        public Builder lifecycleStatus(String var1);

        public Builder lifecycleStatus(JobLifecycleStatus var1);

        public Builder lifecycleStatusMessage(String var1);

        public Builder taskRunStatus(String var1);

        public Builder taskRunStatus(TaskRunStatus var1);

        public Builder targetTaskRunStatus(String var1);

        public Builder targetTaskRunStatus(JobTargetTaskRunStatus var1);

        public Builder taskRunStatusCountsWithStrings(Map<String, Integer> var1);

        public Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> var1);

        public Builder priority(Integer var1);

        public Builder maxFailedTasksCount(Integer var1);

        public Builder maxRetriesPerTask(Integer var1);

        public Builder createdBy(String var1);

        public Builder createdAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder jobParameters(Map<String, JobParameter> var1);

        public Builder sourceJobId(String var1);
    }
}

