/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GroupType {
    DISTRIBUTION("Distribution"),
    SECURITY("Security"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GroupType> VALUE_MAP;
    private final String value;

    private GroupType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GroupType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GroupType> knownValues() {
        EnumSet<GroupType> knownValues = EnumSet.allOf(GroupType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GroupType.class, GroupType::toString);
    }
}

