/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2instanceconnect.internal;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectServiceClientConfiguration;
import software.amazon.awssdk.services.ec2instanceconnect.auth.scheme.Ec2InstanceConnectAuthSchemeProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Ec2InstanceConnectServiceClientConfigurationBuilder
implements Ec2InstanceConnectServiceClientConfiguration.Builder {
    private final SdkClientConfiguration.Builder config;

    public Ec2InstanceConnectServiceClientConfigurationBuilder() {
        this(SdkClientConfiguration.builder());
    }

    public Ec2InstanceConnectServiceClientConfigurationBuilder(SdkClientConfiguration.Builder config) {
        this.config = config;
    }

    @Override
    public Ec2InstanceConnectServiceClientConfiguration.Builder overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.config.putAll(overrideConfiguration);
        return this;
    }

    @Override
    public ClientOverrideConfiguration overrideConfiguration() {
        return (ClientOverrideConfiguration)this.config.asOverrideConfigurationBuilder().build();
    }

    @Override
    public Ec2InstanceConnectServiceClientConfiguration.Builder endpointOverride(URI endpointOverride) {
        if (endpointOverride != null) {
            this.config.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER, (Object)ClientEndpointProvider.forEndpointOverride((URI)endpointOverride));
        } else {
            this.config.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER, null);
        }
        return this;
    }

    @Override
    public URI endpointOverride() {
        ClientEndpointProvider clientEndpoint = (ClientEndpointProvider)this.config.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER);
        if (clientEndpoint != null && clientEndpoint.isEndpointOverridden()) {
            return clientEndpoint.clientEndpoint();
        }
        return null;
    }

    @Override
    public Ec2InstanceConnectServiceClientConfiguration.Builder endpointProvider(EndpointProvider endpointProvider) {
        this.config.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    @Override
    public EndpointProvider endpointProvider() {
        return (EndpointProvider)this.config.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
    }

    @Override
    public Ec2InstanceConnectServiceClientConfiguration.Builder region(Region region) {
        this.config.option((ClientOption)AwsClientOption.AWS_REGION, (Object)region);
        return this;
    }

    @Override
    public Region region() {
        return (Region)this.config.option((ClientOption)AwsClientOption.AWS_REGION);
    }

    @Override
    public Ec2InstanceConnectServiceClientConfiguration.Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
        this.config.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, credentialsProvider);
        return this;
    }

    @Override
    public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider() {
        return (IdentityProvider)this.config.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
    }

    @Override
    public Ec2InstanceConnectServiceClientConfiguration.Builder putAuthScheme(AuthScheme<?> authScheme) {
        ((Map)this.config.computeOptionIfAbsent((ClientOption)SdkClientOption.AUTH_SCHEMES, HashMap::new)).put(authScheme.schemeId(), authScheme);
        return this;
    }

    @Override
    public Map<String, AuthScheme<?>> authSchemes() {
        Map authSchemes = (Map)this.config.option((ClientOption)SdkClientOption.AUTH_SCHEMES);
        return Collections.unmodifiableMap(authSchemes == null ? Collections.emptyMap() : authSchemes);
    }

    @Override
    public Ec2InstanceConnectServiceClientConfiguration.Builder authSchemeProvider(Ec2InstanceConnectAuthSchemeProvider authSchemeProvider) {
        this.config.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)authSchemeProvider);
        return this;
    }

    @Override
    public Ec2InstanceConnectAuthSchemeProvider authSchemeProvider() {
        AuthSchemeProvider result = (AuthSchemeProvider)this.config.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER);
        if (result == null) {
            return null;
        }
        return (Ec2InstanceConnectAuthSchemeProvider)Validate.isInstanceOf(Ec2InstanceConnectAuthSchemeProvider.class, (Object)result, (String)("Expected an instance of " + Ec2InstanceConnectAuthSchemeProvider.class.getSimpleName()), (Object[])new Object[0]);
    }

    @Override
    public Ec2InstanceConnectServiceClientConfiguration build() {
        return new Ec2InstanceConnectServiceClientConfiguration(this);
    }
}

