/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecrpublic.EcrPublicAsyncClient;
import software.amazon.awssdk.services.ecrpublic.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageTagDetail;

public class DescribeImageTagsPublisher
implements SdkPublisher<DescribeImageTagsResponse> {
    private final EcrPublicAsyncClient client;
    private final DescribeImageTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImageTagsPublisher(EcrPublicAsyncClient client, DescribeImageTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImageTagsPublisher(EcrPublicAsyncClient client, DescribeImageTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImageTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImageTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageTagDetail> imageTagDetails() {
        Function<DescribeImageTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageTagDetails() != null) {
                return response.imageTagDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeImageTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeImageTagsResponseFetcher
    implements AsyncPageFetcher<DescribeImageTagsResponse> {
        private DescribeImageTagsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImageTagsResponse> nextPage(DescribeImageTagsResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageTagsPublisher.this.client.describeImageTags(DescribeImageTagsPublisher.this.firstRequest);
            }
            return DescribeImageTagsPublisher.this.client.describeImageTags((DescribeImageTagsRequest)((Object)DescribeImageTagsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

