/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emrcontainers.EmrContainersAsyncClient;
import software.amazon.awssdk.services.emrcontainers.internal.UserAgentUtils;
import software.amazon.awssdk.services.emrcontainers.model.ListVirtualClustersRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListVirtualClustersResponse;
import software.amazon.awssdk.services.emrcontainers.model.VirtualCluster;

public class ListVirtualClustersPublisher
implements SdkPublisher<ListVirtualClustersResponse> {
    private final EmrContainersAsyncClient client;
    private final ListVirtualClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVirtualClustersPublisher(EmrContainersAsyncClient client, ListVirtualClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVirtualClustersPublisher(EmrContainersAsyncClient client, ListVirtualClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVirtualClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVirtualClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VirtualCluster> virtualClusters() {
        Function<ListVirtualClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualClusters() != null) {
                return response.virtualClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVirtualClustersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVirtualClustersResponseFetcher
    implements AsyncPageFetcher<ListVirtualClustersResponse> {
        private ListVirtualClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVirtualClustersResponse> nextPage(ListVirtualClustersResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualClustersPublisher.this.client.listVirtualClusters(ListVirtualClustersPublisher.this.firstRequest);
            }
            return ListVirtualClustersPublisher.this.client.listVirtualClusters((ListVirtualClustersRequest)((Object)ListVirtualClustersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

