/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emrserverless.EmrServerlessAsyncClient;
import software.amazon.awssdk.services.emrserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.emrserverless.model.JobRunAttemptSummary;
import software.amazon.awssdk.services.emrserverless.model.ListJobRunAttemptsRequest;
import software.amazon.awssdk.services.emrserverless.model.ListJobRunAttemptsResponse;

public class ListJobRunAttemptsPublisher
implements SdkPublisher<ListJobRunAttemptsResponse> {
    private final EmrServerlessAsyncClient client;
    private final ListJobRunAttemptsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobRunAttemptsPublisher(EmrServerlessAsyncClient client, ListJobRunAttemptsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobRunAttemptsPublisher(EmrServerlessAsyncClient client, ListJobRunAttemptsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobRunAttemptsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobRunAttemptsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobRunAttemptSummary> jobRunAttempts() {
        Function<ListJobRunAttemptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobRunAttempts() != null) {
                return response.jobRunAttempts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobRunAttemptsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobRunAttemptsResponseFetcher
    implements AsyncPageFetcher<ListJobRunAttemptsResponse> {
        private ListJobRunAttemptsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobRunAttemptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobRunAttemptsResponse> nextPage(ListJobRunAttemptsResponse previousPage) {
            if (previousPage == null) {
                return ListJobRunAttemptsPublisher.this.client.listJobRunAttempts(ListJobRunAttemptsPublisher.this.firstRequest);
            }
            return ListJobRunAttemptsPublisher.this.client.listJobRunAttempts((ListJobRunAttemptsRequest)((Object)ListJobRunAttemptsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

