/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.SchemaMappingListCopier;
import software.amazon.awssdk.services.entityresolution.model.SchemaMappingSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchemaMappingsResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, ListSchemaMappingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSchemaMappingsResponse.getter(ListSchemaMappingsResponse::nextToken)).setter(ListSchemaMappingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SchemaMappingSummary>> SCHEMA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schemaList").getter(ListSchemaMappingsResponse.getter(ListSchemaMappingsResponse::schemaList)).setter(ListSchemaMappingsResponse.setter(Builder::schemaList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaMappingSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEMA_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("schemaList", SCHEMA_LIST_FIELD);
        }
    });
    private final String nextToken;
    private final List<SchemaMappingSummary> schemaList;

    private ListSchemaMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.schemaList = builder.schemaList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSchemaList() {
        return this.schemaList != null && !(this.schemaList instanceof SdkAutoConstructList);
    }

    public final List<SchemaMappingSummary> schemaList() {
        return this.schemaList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaList() ? this.schemaList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemaMappingsResponse)) {
            return false;
        }
        ListSchemaMappingsResponse other = (ListSchemaMappingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSchemaList() == other.hasSchemaList() && Objects.equals(this.schemaList(), other.schemaList());
    }

    public final String toString() {
        return ToString.builder((String)"ListSchemaMappingsResponse").add("NextToken", (Object)this.nextToken()).add("SchemaList", this.hasSchemaList() ? this.schemaList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "schemaList": {
                return Optional.ofNullable(clazz.cast(this.schemaList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemaMappingsResponse, T> g) {
        return obj -> g.apply((ListSchemaMappingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SchemaMappingSummary> schemaList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemaMappingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.schemaList(model.schemaList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SchemaMappingSummary.Builder> getSchemaList() {
            List<SchemaMappingSummary.Builder> result = SchemaMappingListCopier.copyToBuilder(this.schemaList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaList(Collection<SchemaMappingSummary.BuilderImpl> schemaList) {
            this.schemaList = SchemaMappingListCopier.copyFromBuilder(schemaList);
        }

        @Override
        public final Builder schemaList(Collection<SchemaMappingSummary> schemaList) {
            this.schemaList = SchemaMappingListCopier.copy(schemaList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaList(SchemaMappingSummary ... schemaList) {
            this.schemaList(Arrays.asList(schemaList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaList(Consumer<SchemaMappingSummary.Builder> ... schemaList) {
            this.schemaList(Stream.of(schemaList).map(c -> (SchemaMappingSummary)((SchemaMappingSummary.Builder)SchemaMappingSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSchemaMappingsResponse build() {
            return new ListSchemaMappingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchemaMappingsResponse> {
        public Builder nextToken(String var1);

        public Builder schemaList(Collection<SchemaMappingSummary> var1);

        public Builder schemaList(SchemaMappingSummary ... var1);

        public Builder schemaList(Consumer<SchemaMappingSummary.Builder> ... var1);
    }
}

