/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.IncrementalRunConfig;
import software.amazon.awssdk.services.entityresolution.model.InputSource;
import software.amazon.awssdk.services.entityresolution.model.InputSourceConfigCopier;
import software.amazon.awssdk.services.entityresolution.model.OutputSource;
import software.amazon.awssdk.services.entityresolution.model.OutputSourceConfigCopier;
import software.amazon.awssdk.services.entityresolution.model.ResolutionTechniques;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMatchingWorkflowResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, UpdateMatchingWorkflowResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateMatchingWorkflowResponse.getter(UpdateMatchingWorkflowResponse::description)).setter(UpdateMatchingWorkflowResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<IncrementalRunConfig> INCREMENTAL_RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("incrementalRunConfig").getter(UpdateMatchingWorkflowResponse.getter(UpdateMatchingWorkflowResponse::incrementalRunConfig)).setter(UpdateMatchingWorkflowResponse.setter(Builder::incrementalRunConfig)).constructor(IncrementalRunConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalRunConfig").build()}).build();
    private static final SdkField<List<InputSource>> INPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputSourceConfig").getter(UpdateMatchingWorkflowResponse.getter(UpdateMatchingWorkflowResponse::inputSourceConfig)).setter(UpdateMatchingWorkflowResponse.setter(Builder::inputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputSourceConfig").getter(UpdateMatchingWorkflowResponse.getter(UpdateMatchingWorkflowResponse::outputSourceConfig)).setter(UpdateMatchingWorkflowResponse.setter(Builder::outputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResolutionTechniques> RESOLUTION_TECHNIQUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resolutionTechniques").getter(UpdateMatchingWorkflowResponse.getter(UpdateMatchingWorkflowResponse::resolutionTechniques)).setter(UpdateMatchingWorkflowResponse.setter(Builder::resolutionTechniques)).constructor(ResolutionTechniques::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionTechniques").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateMatchingWorkflowResponse.getter(UpdateMatchingWorkflowResponse::roleArn)).setter(UpdateMatchingWorkflowResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowName").getter(UpdateMatchingWorkflowResponse.getter(UpdateMatchingWorkflowResponse::workflowName)).setter(UpdateMatchingWorkflowResponse.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, INCREMENTAL_RUN_CONFIG_FIELD, INPUT_SOURCE_CONFIG_FIELD, OUTPUT_SOURCE_CONFIG_FIELD, RESOLUTION_TECHNIQUES_FIELD, ROLE_ARN_FIELD, WORKFLOW_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("description", DESCRIPTION_FIELD);
            this.put("incrementalRunConfig", INCREMENTAL_RUN_CONFIG_FIELD);
            this.put("inputSourceConfig", INPUT_SOURCE_CONFIG_FIELD);
            this.put("outputSourceConfig", OUTPUT_SOURCE_CONFIG_FIELD);
            this.put("resolutionTechniques", RESOLUTION_TECHNIQUES_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("workflowName", WORKFLOW_NAME_FIELD);
        }
    });
    private final String description;
    private final IncrementalRunConfig incrementalRunConfig;
    private final List<InputSource> inputSourceConfig;
    private final List<OutputSource> outputSourceConfig;
    private final ResolutionTechniques resolutionTechniques;
    private final String roleArn;
    private final String workflowName;

    private UpdateMatchingWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.incrementalRunConfig = builder.incrementalRunConfig;
        this.inputSourceConfig = builder.inputSourceConfig;
        this.outputSourceConfig = builder.outputSourceConfig;
        this.resolutionTechniques = builder.resolutionTechniques;
        this.roleArn = builder.roleArn;
        this.workflowName = builder.workflowName;
    }

    public final String description() {
        return this.description;
    }

    public final IncrementalRunConfig incrementalRunConfig() {
        return this.incrementalRunConfig;
    }

    public final boolean hasInputSourceConfig() {
        return this.inputSourceConfig != null && !(this.inputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<InputSource> inputSourceConfig() {
        return this.inputSourceConfig;
    }

    public final boolean hasOutputSourceConfig() {
        return this.outputSourceConfig != null && !(this.outputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<OutputSource> outputSourceConfig() {
        return this.outputSourceConfig;
    }

    public final ResolutionTechniques resolutionTechniques() {
        return this.resolutionTechniques;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.incrementalRunConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputSourceConfig() ? this.inputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSourceConfig() ? this.outputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionTechniques());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMatchingWorkflowResponse)) {
            return false;
        }
        UpdateMatchingWorkflowResponse other = (UpdateMatchingWorkflowResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.incrementalRunConfig(), other.incrementalRunConfig()) && this.hasInputSourceConfig() == other.hasInputSourceConfig() && Objects.equals(this.inputSourceConfig(), other.inputSourceConfig()) && this.hasOutputSourceConfig() == other.hasOutputSourceConfig() && Objects.equals(this.outputSourceConfig(), other.outputSourceConfig()) && Objects.equals(this.resolutionTechniques(), other.resolutionTechniques()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.workflowName(), other.workflowName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMatchingWorkflowResponse").add("Description", (Object)this.description()).add("IncrementalRunConfig", (Object)this.incrementalRunConfig()).add("InputSourceConfig", this.hasInputSourceConfig() ? this.inputSourceConfig() : null).add("OutputSourceConfig", this.hasOutputSourceConfig() ? this.outputSourceConfig() : null).add("ResolutionTechniques", (Object)this.resolutionTechniques()).add("RoleArn", (Object)this.roleArn()).add("WorkflowName", (Object)this.workflowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "incrementalRunConfig": {
                return Optional.ofNullable(clazz.cast(this.incrementalRunConfig()));
            }
            case "inputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.inputSourceConfig()));
            }
            case "outputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.outputSourceConfig()));
            }
            case "resolutionTechniques": {
                return Optional.ofNullable(clazz.cast(this.resolutionTechniques()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "workflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMatchingWorkflowResponse, T> g) {
        return obj -> g.apply((UpdateMatchingWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private String description;
        private IncrementalRunConfig incrementalRunConfig;
        private List<InputSource> inputSourceConfig = DefaultSdkAutoConstructList.getInstance();
        private List<OutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();
        private ResolutionTechniques resolutionTechniques;
        private String roleArn;
        private String workflowName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMatchingWorkflowResponse model) {
            super(model);
            this.description(model.description);
            this.incrementalRunConfig(model.incrementalRunConfig);
            this.inputSourceConfig(model.inputSourceConfig);
            this.outputSourceConfig(model.outputSourceConfig);
            this.resolutionTechniques(model.resolutionTechniques);
            this.roleArn(model.roleArn);
            this.workflowName(model.workflowName);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IncrementalRunConfig.Builder getIncrementalRunConfig() {
            return this.incrementalRunConfig != null ? this.incrementalRunConfig.toBuilder() : null;
        }

        public final void setIncrementalRunConfig(IncrementalRunConfig.BuilderImpl incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig != null ? incrementalRunConfig.build() : null;
        }

        @Override
        public final Builder incrementalRunConfig(IncrementalRunConfig incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig;
            return this;
        }

        public final List<InputSource.Builder> getInputSourceConfig() {
            List<InputSource.Builder> result = InputSourceConfigCopier.copyToBuilder(this.inputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSourceConfig(Collection<InputSource.BuilderImpl> inputSourceConfig) {
            this.inputSourceConfig = InputSourceConfigCopier.copyFromBuilder(inputSourceConfig);
        }

        @Override
        public final Builder inputSourceConfig(Collection<InputSource> inputSourceConfig) {
            this.inputSourceConfig = InputSourceConfigCopier.copy(inputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(InputSource ... inputSourceConfig) {
            this.inputSourceConfig(Arrays.asList(inputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(Consumer<InputSource.Builder> ... inputSourceConfig) {
            this.inputSourceConfig(Stream.of(inputSourceConfig).map(c -> (InputSource)((InputSource.Builder)InputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OutputSource.Builder> getOutputSourceConfig() {
            List<OutputSource.Builder> result = OutputSourceConfigCopier.copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<OutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = OutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<OutputSource> outputSourceConfig) {
            this.outputSourceConfig = OutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(OutputSource ... outputSourceConfig) {
            this.outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<OutputSource.Builder> ... outputSourceConfig) {
            this.outputSourceConfig(Stream.of(outputSourceConfig).map(c -> (OutputSource)((OutputSource.Builder)OutputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResolutionTechniques.Builder getResolutionTechniques() {
            return this.resolutionTechniques != null ? this.resolutionTechniques.toBuilder() : null;
        }

        public final void setResolutionTechniques(ResolutionTechniques.BuilderImpl resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques != null ? resolutionTechniques.build() : null;
        }

        @Override
        public final Builder resolutionTechniques(ResolutionTechniques resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        @Override
        public UpdateMatchingWorkflowResponse build() {
            return new UpdateMatchingWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMatchingWorkflowResponse> {
        public Builder description(String var1);

        public Builder incrementalRunConfig(IncrementalRunConfig var1);

        default public Builder incrementalRunConfig(Consumer<IncrementalRunConfig.Builder> incrementalRunConfig) {
            return this.incrementalRunConfig((IncrementalRunConfig)((IncrementalRunConfig.Builder)IncrementalRunConfig.builder().applyMutation(incrementalRunConfig)).build());
        }

        public Builder inputSourceConfig(Collection<InputSource> var1);

        public Builder inputSourceConfig(InputSource ... var1);

        public Builder inputSourceConfig(Consumer<InputSource.Builder> ... var1);

        public Builder outputSourceConfig(Collection<OutputSource> var1);

        public Builder outputSourceConfig(OutputSource ... var1);

        public Builder outputSourceConfig(Consumer<OutputSource.Builder> ... var1);

        public Builder resolutionTechniques(ResolutionTechniques var1);

        default public Builder resolutionTechniques(Consumer<ResolutionTechniques.Builder> resolutionTechniques) {
            return this.resolutionTechniques((ResolutionTechniques)((ResolutionTechniques.Builder)ResolutionTechniques.builder().applyMutation(resolutionTechniques)).build());
        }

        public Builder roleArn(String var1);

        public Builder workflowName(String var1);
    }
}

