/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.IncrementalRunConfig;
import software.amazon.awssdk.services.entityresolution.model.InputSource;
import software.amazon.awssdk.services.entityresolution.model.InputSourceConfigCopier;
import software.amazon.awssdk.services.entityresolution.model.OutputSource;
import software.amazon.awssdk.services.entityresolution.model.OutputSourceConfigCopier;
import software.amazon.awssdk.services.entityresolution.model.ResolutionTechniques;
import software.amazon.awssdk.services.entityresolution.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMatchingWorkflowResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, GetMatchingWorkflowResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::createdAt)).setter(GetMatchingWorkflowResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::description)).setter(GetMatchingWorkflowResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<IncrementalRunConfig> INCREMENTAL_RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("incrementalRunConfig").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::incrementalRunConfig)).setter(GetMatchingWorkflowResponse.setter(Builder::incrementalRunConfig)).constructor(IncrementalRunConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalRunConfig").build()}).build();
    private static final SdkField<List<InputSource>> INPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputSourceConfig").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::inputSourceConfig)).setter(GetMatchingWorkflowResponse.setter(Builder::inputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputSourceConfig").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::outputSourceConfig)).setter(GetMatchingWorkflowResponse.setter(Builder::outputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResolutionTechniques> RESOLUTION_TECHNIQUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resolutionTechniques").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::resolutionTechniques)).setter(GetMatchingWorkflowResponse.setter(Builder::resolutionTechniques)).constructor(ResolutionTechniques::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionTechniques").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::roleArn)).setter(GetMatchingWorkflowResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::tags)).setter(GetMatchingWorkflowResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::updatedAt)).setter(GetMatchingWorkflowResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowArn").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::workflowArn)).setter(GetMatchingWorkflowResponse.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowArn").build()}).build();
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowName").getter(GetMatchingWorkflowResponse.getter(GetMatchingWorkflowResponse::workflowName)).setter(GetMatchingWorkflowResponse.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DESCRIPTION_FIELD, INCREMENTAL_RUN_CONFIG_FIELD, INPUT_SOURCE_CONFIG_FIELD, OUTPUT_SOURCE_CONFIG_FIELD, RESOLUTION_TECHNIQUES_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, UPDATED_AT_FIELD, WORKFLOW_ARN_FIELD, WORKFLOW_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMatchingWorkflowResponse.memberNameToFieldInitializer();
    private final Instant createdAt;
    private final String description;
    private final IncrementalRunConfig incrementalRunConfig;
    private final List<InputSource> inputSourceConfig;
    private final List<OutputSource> outputSourceConfig;
    private final ResolutionTechniques resolutionTechniques;
    private final String roleArn;
    private final Map<String, String> tags;
    private final Instant updatedAt;
    private final String workflowArn;
    private final String workflowName;

    private GetMatchingWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.incrementalRunConfig = builder.incrementalRunConfig;
        this.inputSourceConfig = builder.inputSourceConfig;
        this.outputSourceConfig = builder.outputSourceConfig;
        this.resolutionTechniques = builder.resolutionTechniques;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
        this.workflowArn = builder.workflowArn;
        this.workflowName = builder.workflowName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final IncrementalRunConfig incrementalRunConfig() {
        return this.incrementalRunConfig;
    }

    public final boolean hasInputSourceConfig() {
        return this.inputSourceConfig != null && !(this.inputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<InputSource> inputSourceConfig() {
        return this.inputSourceConfig;
    }

    public final boolean hasOutputSourceConfig() {
        return this.outputSourceConfig != null && !(this.outputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<OutputSource> outputSourceConfig() {
        return this.outputSourceConfig;
    }

    public final ResolutionTechniques resolutionTechniques() {
        return this.resolutionTechniques;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.incrementalRunConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputSourceConfig() ? this.inputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSourceConfig() ? this.outputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionTechniques());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMatchingWorkflowResponse)) {
            return false;
        }
        GetMatchingWorkflowResponse other = (GetMatchingWorkflowResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.incrementalRunConfig(), other.incrementalRunConfig()) && this.hasInputSourceConfig() == other.hasInputSourceConfig() && Objects.equals(this.inputSourceConfig(), other.inputSourceConfig()) && this.hasOutputSourceConfig() == other.hasOutputSourceConfig() && Objects.equals(this.outputSourceConfig(), other.outputSourceConfig()) && Objects.equals(this.resolutionTechniques(), other.resolutionTechniques()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.workflowName(), other.workflowName());
    }

    public final String toString() {
        return ToString.builder((String)"GetMatchingWorkflowResponse").add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("IncrementalRunConfig", (Object)this.incrementalRunConfig()).add("InputSourceConfig", this.hasInputSourceConfig() ? this.inputSourceConfig() : null).add("OutputSourceConfig", this.hasOutputSourceConfig() ? this.outputSourceConfig() : null).add("ResolutionTechniques", (Object)this.resolutionTechniques()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("UpdatedAt", (Object)this.updatedAt()).add("WorkflowArn", (Object)this.workflowArn()).add("WorkflowName", (Object)this.workflowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "incrementalRunConfig": {
                return Optional.ofNullable(clazz.cast(this.incrementalRunConfig()));
            }
            case "inputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.inputSourceConfig()));
            }
            case "outputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.outputSourceConfig()));
            }
            case "resolutionTechniques": {
                return Optional.ofNullable(clazz.cast(this.resolutionTechniques()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "workflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "workflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("incrementalRunConfig", INCREMENTAL_RUN_CONFIG_FIELD);
        map.put("inputSourceConfig", INPUT_SOURCE_CONFIG_FIELD);
        map.put("outputSourceConfig", OUTPUT_SOURCE_CONFIG_FIELD);
        map.put("resolutionTechniques", RESOLUTION_TECHNIQUES_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("workflowArn", WORKFLOW_ARN_FIELD);
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMatchingWorkflowResponse, T> g) {
        return obj -> g.apply((GetMatchingWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String description;
        private IncrementalRunConfig incrementalRunConfig;
        private List<InputSource> inputSourceConfig = DefaultSdkAutoConstructList.getInstance();
        private List<OutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();
        private ResolutionTechniques resolutionTechniques;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updatedAt;
        private String workflowArn;
        private String workflowName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMatchingWorkflowResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.incrementalRunConfig(model.incrementalRunConfig);
            this.inputSourceConfig(model.inputSourceConfig);
            this.outputSourceConfig(model.outputSourceConfig);
            this.resolutionTechniques(model.resolutionTechniques);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.updatedAt(model.updatedAt);
            this.workflowArn(model.workflowArn);
            this.workflowName(model.workflowName);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IncrementalRunConfig.Builder getIncrementalRunConfig() {
            return this.incrementalRunConfig != null ? this.incrementalRunConfig.toBuilder() : null;
        }

        public final void setIncrementalRunConfig(IncrementalRunConfig.BuilderImpl incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig != null ? incrementalRunConfig.build() : null;
        }

        @Override
        public final Builder incrementalRunConfig(IncrementalRunConfig incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig;
            return this;
        }

        public final List<InputSource.Builder> getInputSourceConfig() {
            List<InputSource.Builder> result = InputSourceConfigCopier.copyToBuilder(this.inputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSourceConfig(Collection<InputSource.BuilderImpl> inputSourceConfig) {
            this.inputSourceConfig = InputSourceConfigCopier.copyFromBuilder(inputSourceConfig);
        }

        @Override
        public final Builder inputSourceConfig(Collection<InputSource> inputSourceConfig) {
            this.inputSourceConfig = InputSourceConfigCopier.copy(inputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(InputSource ... inputSourceConfig) {
            this.inputSourceConfig(Arrays.asList(inputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(Consumer<InputSource.Builder> ... inputSourceConfig) {
            this.inputSourceConfig(Stream.of(inputSourceConfig).map(c -> (InputSource)((InputSource.Builder)InputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OutputSource.Builder> getOutputSourceConfig() {
            List<OutputSource.Builder> result = OutputSourceConfigCopier.copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<OutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = OutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<OutputSource> outputSourceConfig) {
            this.outputSourceConfig = OutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(OutputSource ... outputSourceConfig) {
            this.outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<OutputSource.Builder> ... outputSourceConfig) {
            this.outputSourceConfig(Stream.of(outputSourceConfig).map(c -> (OutputSource)((OutputSource.Builder)OutputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResolutionTechniques.Builder getResolutionTechniques() {
            return this.resolutionTechniques != null ? this.resolutionTechniques.toBuilder() : null;
        }

        public final void setResolutionTechniques(ResolutionTechniques.BuilderImpl resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques != null ? resolutionTechniques.build() : null;
        }

        @Override
        public final Builder resolutionTechniques(ResolutionTechniques resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        @Override
        public GetMatchingWorkflowResponse build() {
            return new GetMatchingWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMatchingWorkflowResponse> {
        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder incrementalRunConfig(IncrementalRunConfig var1);

        default public Builder incrementalRunConfig(Consumer<IncrementalRunConfig.Builder> incrementalRunConfig) {
            return this.incrementalRunConfig((IncrementalRunConfig)((IncrementalRunConfig.Builder)IncrementalRunConfig.builder().applyMutation(incrementalRunConfig)).build());
        }

        public Builder inputSourceConfig(Collection<InputSource> var1);

        public Builder inputSourceConfig(InputSource ... var1);

        public Builder inputSourceConfig(Consumer<InputSource.Builder> ... var1);

        public Builder outputSourceConfig(Collection<OutputSource> var1);

        public Builder outputSourceConfig(OutputSource ... var1);

        public Builder outputSourceConfig(Consumer<OutputSource.Builder> ... var1);

        public Builder resolutionTechniques(ResolutionTechniques var1);

        default public Builder resolutionTechniques(Consumer<ResolutionTechniques.Builder> resolutionTechniques) {
            return this.resolutionTechniques((ResolutionTechniques)((ResolutionTechniques.Builder)ResolutionTechniques.builder().applyMutation(resolutionTechniques)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder updatedAt(Instant var1);

        public Builder workflowArn(String var1);

        public Builder workflowName(String var1);
    }
}

