/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.AwsAccountIdListCopier;
import software.amazon.awssdk.services.entityresolution.model.RequiredBucketActionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProviderIntermediateDataAccessConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProviderIntermediateDataAccessConfiguration> {
    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("awsAccountIds").getter(ProviderIntermediateDataAccessConfiguration.getter(ProviderIntermediateDataAccessConfiguration::awsAccountIds)).setter(ProviderIntermediateDataAccessConfiguration.setter(Builder::awsAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REQUIRED_BUCKET_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiredBucketActions").getter(ProviderIntermediateDataAccessConfiguration.getter(ProviderIntermediateDataAccessConfiguration::requiredBucketActions)).setter(ProviderIntermediateDataAccessConfiguration.setter(Builder::requiredBucketActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredBucketActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_IDS_FIELD, REQUIRED_BUCKET_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProviderIntermediateDataAccessConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> awsAccountIds;
    private final List<String> requiredBucketActions;

    private ProviderIntermediateDataAccessConfiguration(BuilderImpl builder) {
        this.awsAccountIds = builder.awsAccountIds;
        this.requiredBucketActions = builder.requiredBucketActions;
    }

    public final boolean hasAwsAccountIds() {
        return this.awsAccountIds != null && !(this.awsAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> awsAccountIds() {
        return this.awsAccountIds;
    }

    public final boolean hasRequiredBucketActions() {
        return this.requiredBucketActions != null && !(this.requiredBucketActions instanceof SdkAutoConstructList);
    }

    public final List<String> requiredBucketActions() {
        return this.requiredBucketActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsAccountIds() ? this.awsAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredBucketActions() ? this.requiredBucketActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderIntermediateDataAccessConfiguration)) {
            return false;
        }
        ProviderIntermediateDataAccessConfiguration other = (ProviderIntermediateDataAccessConfiguration)obj;
        return this.hasAwsAccountIds() == other.hasAwsAccountIds() && Objects.equals(this.awsAccountIds(), other.awsAccountIds()) && this.hasRequiredBucketActions() == other.hasRequiredBucketActions() && Objects.equals(this.requiredBucketActions(), other.requiredBucketActions());
    }

    public final String toString() {
        return ToString.builder((String)"ProviderIntermediateDataAccessConfiguration").add("AwsAccountIds", this.hasAwsAccountIds() ? this.awsAccountIds() : null).add("RequiredBucketActions", this.hasRequiredBucketActions() ? this.requiredBucketActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountIds": {
                return Optional.ofNullable(clazz.cast(this.awsAccountIds()));
            }
            case "requiredBucketActions": {
                return Optional.ofNullable(clazz.cast(this.requiredBucketActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("awsAccountIds", AWS_ACCOUNT_IDS_FIELD);
        map.put("requiredBucketActions", REQUIRED_BUCKET_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderIntermediateDataAccessConfiguration, T> g) {
        return obj -> g.apply((ProviderIntermediateDataAccessConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> requiredBucketActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderIntermediateDataAccessConfiguration model) {
            this.awsAccountIds(model.awsAccountIds);
            this.requiredBucketActions(model.requiredBucketActions);
        }

        public final Collection<String> getAwsAccountIds() {
            if (this.awsAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsAccountIds;
        }

        public final void setAwsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AwsAccountIdListCopier.copy(awsAccountIds);
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AwsAccountIdListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String ... awsAccountIds) {
            this.awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final Collection<String> getRequiredBucketActions() {
            if (this.requiredBucketActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredBucketActions;
        }

        public final void setRequiredBucketActions(Collection<String> requiredBucketActions) {
            this.requiredBucketActions = RequiredBucketActionsListCopier.copy(requiredBucketActions);
        }

        @Override
        public final Builder requiredBucketActions(Collection<String> requiredBucketActions) {
            this.requiredBucketActions = RequiredBucketActionsListCopier.copy(requiredBucketActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredBucketActions(String ... requiredBucketActions) {
            this.requiredBucketActions(Arrays.asList(requiredBucketActions));
            return this;
        }

        public ProviderIntermediateDataAccessConfiguration build() {
            return new ProviderIntermediateDataAccessConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProviderIntermediateDataAccessConfiguration> {
        public Builder awsAccountIds(Collection<String> var1);

        public Builder awsAccountIds(String ... var1);

        public Builder requiredBucketActions(Collection<String> var1);

        public Builder requiredBucketActions(String ... var1);
    }
}

