/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.Tag;
import software.amazon.awssdk.services.forecast.model.TagsCopier;
import software.amazon.awssdk.services.forecast.model.TimeSeriesSelector;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWhatIfAnalysisRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateWhatIfAnalysisRequest> {
    private static final SdkField<String> WHAT_IF_ANALYSIS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhatIfAnalysisName").getter(CreateWhatIfAnalysisRequest.getter(CreateWhatIfAnalysisRequest::whatIfAnalysisName)).setter(CreateWhatIfAnalysisRequest.setter(Builder::whatIfAnalysisName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfAnalysisName").build()}).build();
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastArn").getter(CreateWhatIfAnalysisRequest.getter(CreateWhatIfAnalysisRequest::forecastArn)).setter(CreateWhatIfAnalysisRequest.setter(Builder::forecastArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()}).build();
    private static final SdkField<TimeSeriesSelector> TIME_SERIES_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSeriesSelector").getter(CreateWhatIfAnalysisRequest.getter(CreateWhatIfAnalysisRequest::timeSeriesSelector)).setter(CreateWhatIfAnalysisRequest.setter(Builder::timeSeriesSelector)).constructor(TimeSeriesSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesSelector").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateWhatIfAnalysisRequest.getter(CreateWhatIfAnalysisRequest::tags)).setter(CreateWhatIfAnalysisRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_ANALYSIS_NAME_FIELD, FORECAST_ARN_FIELD, TIME_SERIES_SELECTOR_FIELD, TAGS_FIELD));
    private final String whatIfAnalysisName;
    private final String forecastArn;
    private final TimeSeriesSelector timeSeriesSelector;
    private final List<Tag> tags;

    private CreateWhatIfAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.whatIfAnalysisName = builder.whatIfAnalysisName;
        this.forecastArn = builder.forecastArn;
        this.timeSeriesSelector = builder.timeSeriesSelector;
        this.tags = builder.tags;
    }

    public final String whatIfAnalysisName() {
        return this.whatIfAnalysisName;
    }

    public final String forecastArn() {
        return this.forecastArn;
    }

    public final TimeSeriesSelector timeSeriesSelector() {
        return this.timeSeriesSelector;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.whatIfAnalysisName());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWhatIfAnalysisRequest)) {
            return false;
        }
        CreateWhatIfAnalysisRequest other = (CreateWhatIfAnalysisRequest)((Object)obj);
        return Objects.equals(this.whatIfAnalysisName(), other.whatIfAnalysisName()) && Objects.equals(this.forecastArn(), other.forecastArn()) && Objects.equals(this.timeSeriesSelector(), other.timeSeriesSelector()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWhatIfAnalysisRequest").add("WhatIfAnalysisName", (Object)this.whatIfAnalysisName()).add("ForecastArn", (Object)this.forecastArn()).add("TimeSeriesSelector", (Object)this.timeSeriesSelector()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WhatIfAnalysisName": {
                return Optional.ofNullable(clazz.cast(this.whatIfAnalysisName()));
            }
            case "ForecastArn": {
                return Optional.ofNullable(clazz.cast(this.forecastArn()));
            }
            case "TimeSeriesSelector": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesSelector()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWhatIfAnalysisRequest, T> g) {
        return obj -> g.apply((CreateWhatIfAnalysisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String whatIfAnalysisName;
        private String forecastArn;
        private TimeSeriesSelector timeSeriesSelector;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWhatIfAnalysisRequest model) {
            super(model);
            this.whatIfAnalysisName(model.whatIfAnalysisName);
            this.forecastArn(model.forecastArn);
            this.timeSeriesSelector(model.timeSeriesSelector);
            this.tags(model.tags);
        }

        public final String getWhatIfAnalysisName() {
            return this.whatIfAnalysisName;
        }

        public final void setWhatIfAnalysisName(String whatIfAnalysisName) {
            this.whatIfAnalysisName = whatIfAnalysisName;
        }

        @Override
        public final Builder whatIfAnalysisName(String whatIfAnalysisName) {
            this.whatIfAnalysisName = whatIfAnalysisName;
            return this;
        }

        public final String getForecastArn() {
            return this.forecastArn;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final TimeSeriesSelector.Builder getTimeSeriesSelector() {
            return this.timeSeriesSelector != null ? this.timeSeriesSelector.toBuilder() : null;
        }

        public final void setTimeSeriesSelector(TimeSeriesSelector.BuilderImpl timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector != null ? timeSeriesSelector.build() : null;
        }

        @Override
        public final Builder timeSeriesSelector(TimeSeriesSelector timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWhatIfAnalysisRequest build() {
            return new CreateWhatIfAnalysisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWhatIfAnalysisRequest> {
        public Builder whatIfAnalysisName(String var1);

        public Builder forecastArn(String var1);

        public Builder timeSeriesSelector(TimeSeriesSelector var1);

        default public Builder timeSeriesSelector(Consumer<TimeSeriesSelector.Builder> timeSeriesSelector) {
            return this.timeSeriesSelector((TimeSeriesSelector)((TimeSeriesSelector.Builder)TimeSeriesSelector.builder().applyMutation(timeSeriesSelector)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

