/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleIncidentSeverity;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleIncidentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteVehicleIncident
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteVehicleIncident> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RouteVehicleIncident.getter(RouteVehicleIncident::description)).setter(RouteVehicleIncident.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTime").getter(RouteVehicleIncident.getter(RouteVehicleIncident::endTime)).setter(RouteVehicleIncident.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(RouteVehicleIncident.getter(RouteVehicleIncident::severityAsString)).setter(RouteVehicleIncident.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(RouteVehicleIncident.getter(RouteVehicleIncident::startTime)).setter(RouteVehicleIncident.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RouteVehicleIncident.getter(RouteVehicleIncident::typeAsString)).setter(RouteVehicleIncident.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, END_TIME_FIELD, SEVERITY_FIELD, START_TIME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Description", DESCRIPTION_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("Severity", SEVERITY_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("Type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String endTime;
    private final String severity;
    private final String startTime;
    private final String type;

    private RouteVehicleIncident(BuilderImpl builder) {
        this.description = builder.description;
        this.endTime = builder.endTime;
        this.severity = builder.severity;
        this.startTime = builder.startTime;
        this.type = builder.type;
    }

    public final String description() {
        return this.description;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final RouteVehicleIncidentSeverity severity() {
        return RouteVehicleIncidentSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final RouteVehicleIncidentType type() {
        return RouteVehicleIncidentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleIncident)) {
            return false;
        }
        RouteVehicleIncident other = (RouteVehicleIncident)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteVehicleIncident").add("Description", (Object)this.description()).add("EndTime", (Object)this.endTime()).add("Severity", (Object)this.severityAsString()).add("StartTime", (Object)this.startTime()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleIncident, T> g) {
        return obj -> g.apply((RouteVehicleIncident)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String endTime;
        private String severity;
        private String startTime;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleIncident model) {
            this.description(model.description);
            this.endTime(model.endTime);
            this.severity(model.severity);
            this.startTime(model.startTime);
            this.type(model.type);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(RouteVehicleIncidentSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RouteVehicleIncidentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RouteVehicleIncident build() {
            return new RouteVehicleIncident(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteVehicleIncident> {
        public Builder description(String var1);

        public Builder endTime(String var1);

        public Builder severity(String var1);

        public Builder severity(RouteVehicleIncidentSeverity var1);

        public Builder startTime(String var1);

        public Builder type(String var1);

        public Builder type(RouteVehicleIncidentType var1);
    }
}

