/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.grafana.GrafanaClient;
import software.amazon.awssdk.services.grafana.internal.UserAgentUtils;
import software.amazon.awssdk.services.grafana.model.ListWorkspaceServiceAccountTokensRequest;
import software.amazon.awssdk.services.grafana.model.ListWorkspaceServiceAccountTokensResponse;
import software.amazon.awssdk.services.grafana.model.ServiceAccountTokenSummary;

public class ListWorkspaceServiceAccountTokensIterable
implements SdkIterable<ListWorkspaceServiceAccountTokensResponse> {
    private final GrafanaClient client;
    private final ListWorkspaceServiceAccountTokensRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkspaceServiceAccountTokensIterable(GrafanaClient client, ListWorkspaceServiceAccountTokensRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkspaceServiceAccountTokensResponseFetcher();
    }

    public Iterator<ListWorkspaceServiceAccountTokensResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceAccountTokenSummary> serviceAccountTokens() {
        Function<ListWorkspaceServiceAccountTokensResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceAccountTokens() != null) {
                return response.serviceAccountTokens().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkspaceServiceAccountTokensResponseFetcher
    implements SyncPageFetcher<ListWorkspaceServiceAccountTokensResponse> {
        private ListWorkspaceServiceAccountTokensResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspaceServiceAccountTokensResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkspaceServiceAccountTokensResponse nextPage(ListWorkspaceServiceAccountTokensResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspaceServiceAccountTokensIterable.this.client.listWorkspaceServiceAccountTokens(ListWorkspaceServiceAccountTokensIterable.this.firstRequest);
            }
            return ListWorkspaceServiceAccountTokensIterable.this.client.listWorkspaceServiceAccountTokens((ListWorkspaceServiceAccountTokensRequest)((Object)ListWorkspaceServiceAccountTokensIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

