/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EphemerisSource {
    CUSTOMER_PROVIDED("CUSTOMER_PROVIDED"),
    SPACE_TRACK("SPACE_TRACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EphemerisSource> VALUE_MAP;
    private final String value;

    private EphemerisSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EphemerisSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EphemerisSource> knownValues() {
        EnumSet<EphemerisSource> knownValues = EnumSet.allOf(EphemerisSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EphemerisSource.class, EphemerisSource::toString);
    }
}

