/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EphemerisInvalidReason {
    METADATA_INVALID("METADATA_INVALID"),
    TIME_RANGE_INVALID("TIME_RANGE_INVALID"),
    TRAJECTORY_INVALID("TRAJECTORY_INVALID"),
    KMS_KEY_INVALID("KMS_KEY_INVALID"),
    VALIDATION_ERROR("VALIDATION_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EphemerisInvalidReason> VALUE_MAP;
    private final String value;

    private EphemerisInvalidReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EphemerisInvalidReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EphemerisInvalidReason> knownValues() {
        EnumSet<EphemerisInvalidReason> knownValues = EnumSet.allOf(EphemerisInvalidReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EphemerisInvalidReason.class, EphemerisInvalidReason::toString);
    }
}

