/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the GuardDuty member account that uses a free trial service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountFreeTrialInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountFreeTrialInfo.Builder, AccountFreeTrialInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AccountFreeTrialInfo::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<DataSourcesFreeTrial> DATA_SOURCES_FIELD = SdkField
            .<DataSourcesFreeTrial> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(AccountFreeTrialInfo::dataSources)).setter(setter(Builder::dataSources))
            .constructor(DataSourcesFreeTrial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final SdkField<List<FreeTrialFeatureConfigurationResult>> FEATURES_FIELD = SdkField
            .<List<FreeTrialFeatureConfigurationResult>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(AccountFreeTrialInfo::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FreeTrialFeatureConfigurationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(FreeTrialFeatureConfigurationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            DATA_SOURCES_FIELD, FEATURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accountId", ACCOUNT_ID_FIELD);
                    put("dataSources", DATA_SOURCES_FIELD);
                    put("features", FEATURES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final DataSourcesFreeTrial dataSources;

    private final List<FreeTrialFeatureConfigurationResult> features;

    private AccountFreeTrialInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.dataSources = builder.dataSources;
        this.features = builder.features;
    }

    /**
     * <p>
     * The account identifier of the GuardDuty member account.
     * </p>
     * 
     * @return The account identifier of the GuardDuty member account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Describes the data source enabled for the GuardDuty member account.
     * </p>
     * 
     * @return Describes the data source enabled for the GuardDuty member account.
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final DataSourcesFreeTrial dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of features enabled for the GuardDuty account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return A list of features enabled for the GuardDuty account.
     */
    public final List<FreeTrialFeatureConfigurationResult> features() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountFreeTrialInfo)) {
            return false;
        }
        AccountFreeTrialInfo other = (AccountFreeTrialInfo) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(dataSources(), other.dataSources())
                && hasFeatures() == other.hasFeatures() && Objects.equals(features(), other.features());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountFreeTrialInfo").add("AccountId", accountId()).add("DataSources", dataSources())
                .add("Features", hasFeatures() ? features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountFreeTrialInfo, T> g) {
        return obj -> g.apply((AccountFreeTrialInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountFreeTrialInfo> {
        /**
         * <p>
         * The account identifier of the GuardDuty member account.
         * </p>
         * 
         * @param accountId
         *        The account identifier of the GuardDuty member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Describes the data source enabled for the GuardDuty member account.
         * </p>
         * 
         * @param dataSources
         *        Describes the data source enabled for the GuardDuty member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSources(DataSourcesFreeTrial dataSources);

        /**
         * <p>
         * Describes the data source enabled for the GuardDuty member account.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourcesFreeTrial.Builder} avoiding
         * the need to create one manually via {@link DataSourcesFreeTrial#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourcesFreeTrial.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSources(DataSourcesFreeTrial)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link DataSourcesFreeTrial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(DataSourcesFreeTrial)
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        default Builder dataSources(Consumer<DataSourcesFreeTrial.Builder> dataSources) {
            return dataSources(DataSourcesFreeTrial.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * A list of features enabled for the GuardDuty account.
         * </p>
         * 
         * @param features
         *        A list of features enabled for the GuardDuty account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<FreeTrialFeatureConfigurationResult> features);

        /**
         * <p>
         * A list of features enabled for the GuardDuty account.
         * </p>
         * 
         * @param features
         *        A list of features enabled for the GuardDuty account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(FreeTrialFeatureConfigurationResult... features);

        /**
         * <p>
         * A list of features enabled for the GuardDuty account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.FreeTrialFeatureConfigurationResult.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.FreeTrialFeatureConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.FreeTrialFeatureConfigurationResult.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #features(List<FreeTrialFeatureConfigurationResult>)}.
         * 
         * @param features
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.FreeTrialFeatureConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(java.util.Collection<FreeTrialFeatureConfigurationResult>)
         */
        Builder features(Consumer<FreeTrialFeatureConfigurationResult.Builder>... features);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private DataSourcesFreeTrial dataSources;

        private List<FreeTrialFeatureConfigurationResult> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountFreeTrialInfo model) {
            accountId(model.accountId);
            dataSources(model.dataSources);
            features(model.features);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Deprecated
        public final DataSourcesFreeTrial.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(DataSourcesFreeTrial.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(DataSourcesFreeTrial dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<FreeTrialFeatureConfigurationResult.Builder> getFeatures() {
            List<FreeTrialFeatureConfigurationResult.Builder> result = FreeTrialFeatureConfigurationsResultsCopier
                    .copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<FreeTrialFeatureConfigurationResult.BuilderImpl> features) {
            this.features = FreeTrialFeatureConfigurationsResultsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<FreeTrialFeatureConfigurationResult> features) {
            this.features = FreeTrialFeatureConfigurationsResultsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(FreeTrialFeatureConfigurationResult... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<FreeTrialFeatureConfigurationResult.Builder>... features) {
            features(Stream.of(features).map(c -> FreeTrialFeatureConfigurationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AccountFreeTrialInfo build() {
            return new AccountFreeTrialInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
