/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a condition that when matched will be added to the response of the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageFilterCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageFilterCondition.Builder, CoverageFilterCondition> {
    private static final SdkField<List<String>> EQUALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Equals")
            .getter(getter(CoverageFilterCondition::equalsValue))
            .setter(setter(Builder::equalsValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_EQUALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotEquals")
            .getter(getter(CoverageFilterCondition::notEquals))
            .setter(setter(Builder::notEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EQUALS_FIELD, NOT_EQUALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("equals", EQUALS_FIELD);
                    put("notEquals", NOT_EQUALS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> equals;

    private final List<String> notEquals;

    private CoverageFilterCondition(BuilderImpl builder) {
        this.equals = builder.equals;
        this.notEquals = builder.notEquals;
    }

    /**
     * For responses, this returns true if the service returned a value for the Equals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEqualsValue() {
        return equals != null && !(equals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents an equal condition that is applied to a single field while retrieving the coverage details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEqualsValue} method.
     * </p>
     * 
     * @return Represents an equal condition that is applied to a single field while retrieving the coverage details.
     */
    public final List<String> equalsValue() {
        return equals;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotEquals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotEquals() {
        return notEquals != null && !(notEquals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a not equal condition that is applied to a single field while retrieving the coverage details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotEquals} method.
     * </p>
     * 
     * @return Represents a not equal condition that is applied to a single field while retrieving the coverage details.
     */
    public final List<String> notEquals() {
        return notEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEqualsValue() ? equalsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotEquals() ? notEquals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageFilterCondition)) {
            return false;
        }
        CoverageFilterCondition other = (CoverageFilterCondition) obj;
        return hasEqualsValue() == other.hasEqualsValue() && Objects.equals(equalsValue(), other.equalsValue())
                && hasNotEquals() == other.hasNotEquals() && Objects.equals(notEquals(), other.notEquals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageFilterCondition").add("Equals", hasEqualsValue() ? equalsValue() : null)
                .add("NotEquals", hasNotEquals() ? notEquals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Equals":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        case "NotEquals":
            return Optional.ofNullable(clazz.cast(notEquals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CoverageFilterCondition, T> g) {
        return obj -> g.apply((CoverageFilterCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageFilterCondition> {
        /**
         * <p>
         * Represents an equal condition that is applied to a single field while retrieving the coverage details.
         * </p>
         * 
         * @param equals
         *        Represents an equal condition that is applied to a single field while retrieving the coverage details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(Collection<String> equals);

        /**
         * <p>
         * Represents an equal condition that is applied to a single field while retrieving the coverage details.
         * </p>
         * 
         * @param equals
         *        Represents an equal condition that is applied to a single field while retrieving the coverage details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(String... equals);

        /**
         * <p>
         * Represents a not equal condition that is applied to a single field while retrieving the coverage details.
         * </p>
         * 
         * @param notEquals
         *        Represents a not equal condition that is applied to a single field while retrieving the coverage
         *        details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(Collection<String> notEquals);

        /**
         * <p>
         * Represents a not equal condition that is applied to a single field while retrieving the coverage details.
         * </p>
         * 
         * @param notEquals
         *        Represents a not equal condition that is applied to a single field while retrieving the coverage
         *        details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(String... notEquals);
    }

    static final class BuilderImpl implements Builder {
        private List<String> equals = DefaultSdkAutoConstructList.getInstance();

        private List<String> notEquals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageFilterCondition model) {
            equalsValue(model.equals);
            notEquals(model.notEquals);
        }

        public final Collection<String> getEqualsValue() {
            if (equals instanceof SdkAutoConstructList) {
                return null;
            }
            return equals;
        }

        public final void setEqualsValue(Collection<String> equals) {
            this.equals = EqualsCopier.copy(equals);
        }

        @Override
        public final Builder equalsValue(Collection<String> equals) {
            this.equals = EqualsCopier.copy(equals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder equalsValue(String... equals) {
            equalsValue(Arrays.asList(equals));
            return this;
        }

        public final Collection<String> getNotEquals() {
            if (notEquals instanceof SdkAutoConstructList) {
                return null;
            }
            return notEquals;
        }

        public final void setNotEquals(Collection<String> notEquals) {
            this.notEquals = NotEqualsCopier.copy(notEquals);
        }

        @Override
        public final Builder notEquals(Collection<String> notEquals) {
            this.notEquals = NotEqualsCopier.copy(notEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notEquals(String... notEquals) {
            notEquals(Arrays.asList(notEquals));
            return this;
        }

        @Override
        public CoverageFilterCondition build() {
            return new CoverageFilterCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
