/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the criteria used in the filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageFilterCriteria.Builder, CoverageFilterCriteria> {
    private static final SdkField<List<CoverageFilterCriterion>> FILTER_CRITERION_FIELD = SdkField
            .<List<CoverageFilterCriterion>> builder(MarshallingType.LIST)
            .memberName("FilterCriterion")
            .getter(getter(CoverageFilterCriteria::filterCriterion))
            .setter(setter(Builder::filterCriterion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriterion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageFilterCriterion> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageFilterCriterion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("filterCriterion", FILTER_CRITERION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<CoverageFilterCriterion> filterCriterion;

    private CoverageFilterCriteria(BuilderImpl builder) {
        this.filterCriterion = builder.filterCriterion;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterCriterion property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterCriterion() {
        return filterCriterion != null && !(filterCriterion instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a condition that when matched will be added to the response of the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterCriterion} method.
     * </p>
     * 
     * @return Represents a condition that when matched will be added to the response of the operation.
     */
    public final List<CoverageFilterCriterion> filterCriterion() {
        return filterCriterion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterCriterion() ? filterCriterion() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageFilterCriteria)) {
            return false;
        }
        CoverageFilterCriteria other = (CoverageFilterCriteria) obj;
        return hasFilterCriterion() == other.hasFilterCriterion() && Objects.equals(filterCriterion(), other.filterCriterion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageFilterCriteria").add("FilterCriterion", hasFilterCriterion() ? filterCriterion() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterCriterion":
            return Optional.ofNullable(clazz.cast(filterCriterion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CoverageFilterCriteria, T> g) {
        return obj -> g.apply((CoverageFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageFilterCriteria> {
        /**
         * <p>
         * Represents a condition that when matched will be added to the response of the operation.
         * </p>
         * 
         * @param filterCriterion
         *        Represents a condition that when matched will be added to the response of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriterion(Collection<CoverageFilterCriterion> filterCriterion);

        /**
         * <p>
         * Represents a condition that when matched will be added to the response of the operation.
         * </p>
         * 
         * @param filterCriterion
         *        Represents a condition that when matched will be added to the response of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriterion(CoverageFilterCriterion... filterCriterion);

        /**
         * <p>
         * Represents a condition that when matched will be added to the response of the operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.CoverageFilterCriterion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.CoverageFilterCriterion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.CoverageFilterCriterion.Builder#build()} is called
         * immediately and its result is passed to {@link #filterCriterion(List<CoverageFilterCriterion>)}.
         * 
         * @param filterCriterion
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.CoverageFilterCriterion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriterion(java.util.Collection<CoverageFilterCriterion>)
         */
        Builder filterCriterion(Consumer<CoverageFilterCriterion.Builder>... filterCriterion);
    }

    static final class BuilderImpl implements Builder {
        private List<CoverageFilterCriterion> filterCriterion = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageFilterCriteria model) {
            filterCriterion(model.filterCriterion);
        }

        public final List<CoverageFilterCriterion.Builder> getFilterCriterion() {
            List<CoverageFilterCriterion.Builder> result = CoverageFilterCriterionListCopier.copyToBuilder(this.filterCriterion);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterCriterion(Collection<CoverageFilterCriterion.BuilderImpl> filterCriterion) {
            this.filterCriterion = CoverageFilterCriterionListCopier.copyFromBuilder(filterCriterion);
        }

        @Override
        public final Builder filterCriterion(Collection<CoverageFilterCriterion> filterCriterion) {
            this.filterCriterion = CoverageFilterCriterionListCopier.copy(filterCriterion);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCriterion(CoverageFilterCriterion... filterCriterion) {
            filterCriterion(Arrays.asList(filterCriterion));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCriterion(Consumer<CoverageFilterCriterion.Builder>... filterCriterion) {
            filterCriterion(Stream.of(filterCriterion).map(c -> CoverageFilterCriterion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CoverageFilterCriteria build() {
            return new CoverageFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
