/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the resource of the GuardDuty account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageResource implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageResource.Builder, CoverageResource> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(CoverageResource::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(CoverageResource::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(CoverageResource::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<CoverageResourceDetails> RESOURCE_DETAILS_FIELD = SdkField
            .<CoverageResourceDetails> builder(MarshallingType.SDK_POJO).memberName("ResourceDetails")
            .getter(getter(CoverageResource::resourceDetails)).setter(setter(Builder::resourceDetails))
            .constructor(CoverageResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDetails").build()).build();

    private static final SdkField<String> COVERAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoverageStatus").getter(getter(CoverageResource::coverageStatusAsString))
            .setter(setter(Builder::coverageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverageStatus").build()).build();

    private static final SdkField<String> ISSUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Issue")
            .getter(getter(CoverageResource::issue)).setter(setter(Builder::issue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issue").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(CoverageResource::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            DETECTOR_ID_FIELD, ACCOUNT_ID_FIELD, RESOURCE_DETAILS_FIELD, COVERAGE_STATUS_FIELD, ISSUE_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("resourceId", RESOURCE_ID_FIELD);
                    put("detectorId", DETECTOR_ID_FIELD);
                    put("accountId", ACCOUNT_ID_FIELD);
                    put("resourceDetails", RESOURCE_DETAILS_FIELD);
                    put("coverageStatus", COVERAGE_STATUS_FIELD);
                    put("issue", ISSUE_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String detectorId;

    private final String accountId;

    private final CoverageResourceDetails resourceDetails;

    private final String coverageStatus;

    private final String issue;

    private final Instant updatedAt;

    private CoverageResource(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.detectorId = builder.detectorId;
        this.accountId = builder.accountId;
        this.resourceDetails = builder.resourceDetails;
        this.coverageStatus = builder.coverageStatus;
        this.issue = builder.issue;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The unique ID of the resource.
     * </p>
     * 
     * @return The unique ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The unique ID of the GuardDuty detector associated with the resource.
     * </p>
     * 
     * @return The unique ID of the GuardDuty detector associated with the resource.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The unique ID of the Amazon Web Services account.
     * </p>
     * 
     * @return The unique ID of the Amazon Web Services account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Information about the resource for which the coverage statistics are retrieved.
     * </p>
     * 
     * @return Information about the resource for which the coverage statistics are retrieved.
     */
    public final CoverageResourceDetails resourceDetails() {
        return resourceDetails;
    }

    /**
     * <p>
     * Represents the status of the EKS cluster coverage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #coverageStatus}
     * will return {@link CoverageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #coverageStatusAsString}.
     * </p>
     * 
     * @return Represents the status of the EKS cluster coverage.
     * @see CoverageStatus
     */
    public final CoverageStatus coverageStatus() {
        return CoverageStatus.fromValue(coverageStatus);
    }

    /**
     * <p>
     * Represents the status of the EKS cluster coverage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #coverageStatus}
     * will return {@link CoverageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #coverageStatusAsString}.
     * </p>
     * 
     * @return Represents the status of the EKS cluster coverage.
     * @see CoverageStatus
     */
    public final String coverageStatusAsString() {
        return coverageStatus;
    }

    /**
     * <p>
     * Represents the reason why a coverage status was <code>UNHEALTHY</code> for the EKS cluster.
     * </p>
     * 
     * @return Represents the reason why a coverage status was <code>UNHEALTHY</code> for the EKS cluster.
     */
    public final String issue() {
        return issue;
    }

    /**
     * <p>
     * The timestamp at which the coverage details for the resource were last updated. This is in UTC format.
     * </p>
     * 
     * @return The timestamp at which the coverage details for the resource were last updated. This is in UTC format.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(coverageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(issue());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageResource)) {
            return false;
        }
        CoverageResource other = (CoverageResource) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(resourceDetails(), other.resourceDetails())
                && Objects.equals(coverageStatusAsString(), other.coverageStatusAsString())
                && Objects.equals(issue(), other.issue()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageResource").add("ResourceId", resourceId()).add("DetectorId", detectorId())
                .add("AccountId", accountId()).add("ResourceDetails", resourceDetails())
                .add("CoverageStatus", coverageStatusAsString()).add("Issue", issue()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ResourceDetails":
            return Optional.ofNullable(clazz.cast(resourceDetails()));
        case "CoverageStatus":
            return Optional.ofNullable(clazz.cast(coverageStatusAsString()));
        case "Issue":
            return Optional.ofNullable(clazz.cast(issue()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CoverageResource, T> g) {
        return obj -> g.apply((CoverageResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageResource> {
        /**
         * <p>
         * The unique ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The unique ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The unique ID of the GuardDuty detector associated with the resource.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the GuardDuty detector associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The unique ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountId
         *        The unique ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Information about the resource for which the coverage statistics are retrieved.
         * </p>
         * 
         * @param resourceDetails
         *        Information about the resource for which the coverage statistics are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetails(CoverageResourceDetails resourceDetails);

        /**
         * <p>
         * Information about the resource for which the coverage statistics are retrieved.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageResourceDetails.Builder} avoiding
         * the need to create one manually via {@link CoverageResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoverageResourceDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceDetails(CoverageResourceDetails)}.
         * 
         * @param resourceDetails
         *        a consumer that will call methods on {@link CoverageResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetails(CoverageResourceDetails)
         */
        default Builder resourceDetails(Consumer<CoverageResourceDetails.Builder> resourceDetails) {
            return resourceDetails(CoverageResourceDetails.builder().applyMutation(resourceDetails).build());
        }

        /**
         * <p>
         * Represents the status of the EKS cluster coverage.
         * </p>
         * 
         * @param coverageStatus
         *        Represents the status of the EKS cluster coverage.
         * @see CoverageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoverageStatus
         */
        Builder coverageStatus(String coverageStatus);

        /**
         * <p>
         * Represents the status of the EKS cluster coverage.
         * </p>
         * 
         * @param coverageStatus
         *        Represents the status of the EKS cluster coverage.
         * @see CoverageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoverageStatus
         */
        Builder coverageStatus(CoverageStatus coverageStatus);

        /**
         * <p>
         * Represents the reason why a coverage status was <code>UNHEALTHY</code> for the EKS cluster.
         * </p>
         * 
         * @param issue
         *        Represents the reason why a coverage status was <code>UNHEALTHY</code> for the EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issue(String issue);

        /**
         * <p>
         * The timestamp at which the coverage details for the resource were last updated. This is in UTC format.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp at which the coverage details for the resource were last updated. This is in UTC format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String detectorId;

        private String accountId;

        private CoverageResourceDetails resourceDetails;

        private String coverageStatus;

        private String issue;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageResource model) {
            resourceId(model.resourceId);
            detectorId(model.detectorId);
            accountId(model.accountId);
            resourceDetails(model.resourceDetails);
            coverageStatus(model.coverageStatus);
            issue(model.issue);
            updatedAt(model.updatedAt);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final CoverageResourceDetails.Builder getResourceDetails() {
            return resourceDetails != null ? resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(CoverageResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(CoverageResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final String getCoverageStatus() {
            return coverageStatus;
        }

        public final void setCoverageStatus(String coverageStatus) {
            this.coverageStatus = coverageStatus;
        }

        @Override
        public final Builder coverageStatus(String coverageStatus) {
            this.coverageStatus = coverageStatus;
            return this;
        }

        @Override
        public final Builder coverageStatus(CoverageStatus coverageStatus) {
            this.coverageStatus(coverageStatus == null ? null : coverageStatus.toString());
            return this;
        }

        public final String getIssue() {
            return issue;
        }

        public final void setIssue(String issue) {
            this.issue = issue;
        }

        @Override
        public final Builder issue(String issue) {
            this.issue = issue;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public CoverageResource build() {
            return new CoverageResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
