/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the server side encryption method used in the S3 bucket. See <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">S3 Server-Side Encryption</a> for
 * more information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultServerSideEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultServerSideEncryption.Builder, DefaultServerSideEncryption> {
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionType").getter(getter(DefaultServerSideEncryption::encryptionType))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()).build();

    private static final SdkField<String> KMS_MASTER_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsMasterKeyArn").getter(getter(DefaultServerSideEncryption::kmsMasterKeyArn))
            .setter(setter(Builder::kmsMasterKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsMasterKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD,
            KMS_MASTER_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("encryptionType", ENCRYPTION_TYPE_FIELD);
                    put("kmsMasterKeyArn", KMS_MASTER_KEY_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String encryptionType;

    private final String kmsMasterKeyArn;

    private DefaultServerSideEncryption(BuilderImpl builder) {
        this.encryptionType = builder.encryptionType;
        this.kmsMasterKeyArn = builder.kmsMasterKeyArn;
    }

    /**
     * <p>
     * The type of encryption used for objects within the S3 bucket.
     * </p>
     * 
     * @return The type of encryption used for objects within the S3 bucket.
     */
    public final String encryptionType() {
        return encryptionType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the bucket
     * <code>EncryptionType</code> is <code>aws:kms</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the bucket
     *         <code>EncryptionType</code> is <code>aws:kms</code>.
     */
    public final String kmsMasterKeyArn() {
        return kmsMasterKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultServerSideEncryption)) {
            return false;
        }
        DefaultServerSideEncryption other = (DefaultServerSideEncryption) obj;
        return Objects.equals(encryptionType(), other.encryptionType())
                && Objects.equals(kmsMasterKeyArn(), other.kmsMasterKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultServerSideEncryption").add("EncryptionType", encryptionType())
                .add("KmsMasterKeyArn", kmsMasterKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionType":
            return Optional.ofNullable(clazz.cast(encryptionType()));
        case "KmsMasterKeyArn":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DefaultServerSideEncryption, T> g) {
        return obj -> g.apply((DefaultServerSideEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultServerSideEncryption> {
        /**
         * <p>
         * The type of encryption used for objects within the S3 bucket.
         * </p>
         * 
         * @param encryptionType
         *        The type of encryption used for objects within the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the bucket
         * <code>EncryptionType</code> is <code>aws:kms</code>.
         * </p>
         * 
         * @param kmsMasterKeyArn
         *        The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the bucket
         *        <code>EncryptionType</code> is <code>aws:kms</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyArn(String kmsMasterKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String encryptionType;

        private String kmsMasterKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultServerSideEncryption model) {
            encryptionType(model.encryptionType);
            kmsMasterKeyArn(model.kmsMasterKeyArn);
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        public final String getKmsMasterKeyArn() {
            return kmsMasterKeyArn;
        }

        public final void setKmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
        }

        @Override
        public final Builder kmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
            return this;
        }

        @Override
        public DefaultServerSideEncryption build() {
            return new DefaultServerSideEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
