/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a GuardDuty feature.
 * </p>
 * <p>
 * Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (
 * <code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime
 * Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a
 * href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorFeatureConfigurationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectorFeatureConfigurationResult.Builder, DetectorFeatureConfigurationResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DetectorFeatureConfigurationResult::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DetectorFeatureConfigurationResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DetectorFeatureConfigurationResult::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<List<DetectorAdditionalConfigurationResult>> ADDITIONAL_CONFIGURATION_FIELD = SdkField
            .<List<DetectorAdditionalConfigurationResult>> builder(MarshallingType.LIST)
            .memberName("AdditionalConfiguration")
            .getter(getter(DetectorFeatureConfigurationResult::additionalConfiguration))
            .setter(setter(Builder::additionalConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectorAdditionalConfigurationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectorAdditionalConfigurationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            UPDATED_AT_FIELD, ADDITIONAL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("status", STATUS_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                    put("additionalConfiguration", ADDITIONAL_CONFIGURATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final Instant updatedAt;

    private final List<DetectorAdditionalConfigurationResult> additionalConfiguration;

    private DetectorFeatureConfigurationResult(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.additionalConfiguration = builder.additionalConfiguration;
    }

    /**
     * <p>
     * Indicates the name of the feature that can be enabled for the detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link DetectorFeatureResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Indicates the name of the feature that can be enabled for the detector.
     * @see DetectorFeatureResult
     */
    public final DetectorFeatureResult name() {
        return DetectorFeatureResult.fromValue(name);
    }

    /**
     * <p>
     * Indicates the name of the feature that can be enabled for the detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link DetectorFeatureResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Indicates the name of the feature that can be enabled for the detector.
     * @see DetectorFeatureResult
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * Indicates the status of the feature that is enabled for the detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the feature that is enabled for the detector.
     * @see FeatureStatus
     */
    public final FeatureStatus status() {
        return FeatureStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the feature that is enabled for the detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the feature that is enabled for the detector.
     * @see FeatureStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp at which the feature object was updated.
     * </p>
     * 
     * @return The timestamp at which the feature object was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalConfiguration() {
        return additionalConfiguration != null && !(additionalConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional configuration for a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalConfiguration} method.
     * </p>
     * 
     * @return Additional configuration for a resource.
     */
    public final List<DetectorAdditionalConfigurationResult> additionalConfiguration() {
        return additionalConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalConfiguration() ? additionalConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorFeatureConfigurationResult)) {
            return false;
        }
        DetectorFeatureConfigurationResult other = (DetectorFeatureConfigurationResult) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt())
                && hasAdditionalConfiguration() == other.hasAdditionalConfiguration()
                && Objects.equals(additionalConfiguration(), other.additionalConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectorFeatureConfigurationResult").add("Name", nameAsString()).add("Status", statusAsString())
                .add("UpdatedAt", updatedAt())
                .add("AdditionalConfiguration", hasAdditionalConfiguration() ? additionalConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "AdditionalConfiguration":
            return Optional.ofNullable(clazz.cast(additionalConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetectorFeatureConfigurationResult, T> g) {
        return obj -> g.apply((DetectorFeatureConfigurationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorFeatureConfigurationResult> {
        /**
         * <p>
         * Indicates the name of the feature that can be enabled for the detector.
         * </p>
         * 
         * @param name
         *        Indicates the name of the feature that can be enabled for the detector.
         * @see DetectorFeatureResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorFeatureResult
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates the name of the feature that can be enabled for the detector.
         * </p>
         * 
         * @param name
         *        Indicates the name of the feature that can be enabled for the detector.
         * @see DetectorFeatureResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorFeatureResult
         */
        Builder name(DetectorFeatureResult name);

        /**
         * <p>
         * Indicates the status of the feature that is enabled for the detector.
         * </p>
         * 
         * @param status
         *        Indicates the status of the feature that is enabled for the detector.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the feature that is enabled for the detector.
         * </p>
         * 
         * @param status
         *        Indicates the status of the feature that is enabled for the detector.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(FeatureStatus status);

        /**
         * <p>
         * The timestamp at which the feature object was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp at which the feature object was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Additional configuration for a resource.
         * </p>
         * 
         * @param additionalConfiguration
         *        Additional configuration for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfiguration(Collection<DetectorAdditionalConfigurationResult> additionalConfiguration);

        /**
         * <p>
         * Additional configuration for a resource.
         * </p>
         * 
         * @param additionalConfiguration
         *        Additional configuration for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfiguration(DetectorAdditionalConfigurationResult... additionalConfiguration);

        /**
         * <p>
         * Additional configuration for a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfigurationResult.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfigurationResult.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #additionalConfiguration(List<DetectorAdditionalConfigurationResult>)}.
         * 
         * @param additionalConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalConfiguration(java.util.Collection<DetectorAdditionalConfigurationResult>)
         */
        Builder additionalConfiguration(Consumer<DetectorAdditionalConfigurationResult.Builder>... additionalConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private Instant updatedAt;

        private List<DetectorAdditionalConfigurationResult> additionalConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorFeatureConfigurationResult model) {
            name(model.name);
            status(model.status);
            updatedAt(model.updatedAt);
            additionalConfiguration(model.additionalConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(DetectorFeatureResult name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<DetectorAdditionalConfigurationResult.Builder> getAdditionalConfiguration() {
            List<DetectorAdditionalConfigurationResult.Builder> result = DetectorAdditionalConfigurationResultsCopier
                    .copyToBuilder(this.additionalConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalConfiguration(
                Collection<DetectorAdditionalConfigurationResult.BuilderImpl> additionalConfiguration) {
            this.additionalConfiguration = DetectorAdditionalConfigurationResultsCopier.copyFromBuilder(additionalConfiguration);
        }

        @Override
        public final Builder additionalConfiguration(Collection<DetectorAdditionalConfigurationResult> additionalConfiguration) {
            this.additionalConfiguration = DetectorAdditionalConfigurationResultsCopier.copy(additionalConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(DetectorAdditionalConfigurationResult... additionalConfiguration) {
            additionalConfiguration(Arrays.asList(additionalConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(
                Consumer<DetectorAdditionalConfigurationResult.Builder>... additionalConfiguration) {
            additionalConfiguration(Stream.of(additionalConfiguration)
                    .map(c -> DetectorAdditionalConfigurationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectorFeatureConfigurationResult build() {
            return new DetectorFeatureConfigurationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
