/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the elastic network interface of the Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2NetworkInterface.Builder, Ec2NetworkInterface> {
    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(Ec2NetworkInterface::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PrivateIpAddressDetails>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<PrivateIpAddressDetails>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(Ec2NetworkInterface::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrivateIpAddressDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateIpAddressDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicIp").getter(getter(Ec2NetworkInterface::publicIp)).setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIp").build()).build();

    private static final SdkField<List<SecurityGroup>> SECURITY_GROUPS_FIELD = SdkField
            .<List<SecurityGroup>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(Ec2NetworkInterface::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUB_NET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubNetId").getter(getter(Ec2NetworkInterface::subNetId)).setter(setter(Builder::subNetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subNetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(Ec2NetworkInterface::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_ADDRESSES_FIELD,
            PRIVATE_IP_ADDRESSES_FIELD, PUBLIC_IP_FIELD, SECURITY_GROUPS_FIELD, SUB_NET_ID_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ipv6Addresses", IPV6_ADDRESSES_FIELD);
                    put("privateIpAddresses", PRIVATE_IP_ADDRESSES_FIELD);
                    put("publicIp", PUBLIC_IP_FIELD);
                    put("securityGroups", SECURITY_GROUPS_FIELD);
                    put("subNetId", SUB_NET_ID_FIELD);
                    put("vpcId", VPC_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> ipv6Addresses;

    private final List<PrivateIpAddressDetails> privateIpAddresses;

    private final String publicIp;

    private final List<SecurityGroup> securityGroups;

    private final String subNetId;

    private final String vpcId;

    private Ec2NetworkInterface(BuilderImpl builder) {
        this.ipv6Addresses = builder.ipv6Addresses;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.publicIp = builder.publicIp;
        this.securityGroups = builder.securityGroups;
        this.subNetId = builder.subNetId;
        this.vpcId = builder.vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IPv6 addresses for the Amazon EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return A list of IPv6 addresses for the Amazon EC2 instance.
     */
    public final List<String> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Other private IP address information of the Amazon EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return Other private IP address information of the Amazon EC2 instance.
     */
    public final List<PrivateIpAddressDetails> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The public IP address of the Amazon EC2 instance.
     * </p>
     * 
     * @return The public IP address of the Amazon EC2 instance.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups associated with the Amazon EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The security groups associated with the Amazon EC2 instance.
     */
    public final List<SecurityGroup> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The subnet ID of the Amazon EC2 instance.
     * </p>
     * 
     * @return The subnet ID of the Amazon EC2 instance.
     */
    public final String subNetId() {
        return subNetId;
    }

    /**
     * <p>
     * The VPC ID of the Amazon EC2 instance.
     * </p>
     * 
     * @return The VPC ID of the Amazon EC2 instance.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subNetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2NetworkInterface)) {
            return false;
        }
        Ec2NetworkInterface other = (Ec2NetworkInterface) obj;
        return hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(publicIp(), other.publicIp()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups()) && Objects.equals(subNetId(), other.subNetId())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2NetworkInterface").add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null)
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null).add("PublicIp", publicIp())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SubNetId", subNetId())
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SubNetId":
            return Optional.ofNullable(clazz.cast(subNetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Ec2NetworkInterface, T> g) {
        return obj -> g.apply((Ec2NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2NetworkInterface> {
        /**
         * <p>
         * A list of IPv6 addresses for the Amazon EC2 instance.
         * </p>
         * 
         * @param ipv6Addresses
         *        A list of IPv6 addresses for the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<String> ipv6Addresses);

        /**
         * <p>
         * A list of IPv6 addresses for the Amazon EC2 instance.
         * </p>
         * 
         * @param ipv6Addresses
         *        A list of IPv6 addresses for the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(String... ipv6Addresses);

        /**
         * <p>
         * Other private IP address information of the Amazon EC2 instance.
         * </p>
         * 
         * @param privateIpAddresses
         *        Other private IP address information of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIpAddressDetails> privateIpAddresses);

        /**
         * <p>
         * Other private IP address information of the Amazon EC2 instance.
         * </p>
         * 
         * @param privateIpAddresses
         *        Other private IP address information of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIpAddressDetails... privateIpAddresses);

        /**
         * <p>
         * Other private IP address information of the Amazon EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpAddresses(List<PrivateIpAddressDetails>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(java.util.Collection<PrivateIpAddressDetails>)
         */
        Builder privateIpAddresses(Consumer<PrivateIpAddressDetails.Builder>... privateIpAddresses);

        /**
         * <p>
         * The public IP address of the Amazon EC2 instance.
         * </p>
         * 
         * @param publicIp
         *        The public IP address of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The security groups associated with the Amazon EC2 instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups associated with the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<SecurityGroup> securityGroups);

        /**
         * <p>
         * The security groups associated with the Amazon EC2 instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups associated with the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(SecurityGroup... securityGroups);

        /**
         * <p>
         * The security groups associated with the Amazon EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.SecurityGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.SecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.SecurityGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #securityGroups(List<SecurityGroup>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.SecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(java.util.Collection<SecurityGroup>)
         */
        Builder securityGroups(Consumer<SecurityGroup.Builder>... securityGroups);

        /**
         * <p>
         * The subnet ID of the Amazon EC2 instance.
         * </p>
         * 
         * @param subNetId
         *        The subnet ID of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subNetId(String subNetId);

        /**
         * <p>
         * The VPC ID of the Amazon EC2 instance.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<PrivateIpAddressDetails> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private String publicIp;

        private List<SecurityGroup> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String subNetId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2NetworkInterface model) {
            ipv6Addresses(model.ipv6Addresses);
            privateIpAddresses(model.privateIpAddresses);
            publicIp(model.publicIp);
            securityGroups(model.securityGroups);
            subNetId(model.subNetId);
            vpcId(model.vpcId);
        }

        public final Collection<String> getIpv6Addresses() {
            if (ipv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipv6Addresses;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final List<PrivateIpAddressDetails.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressDetails.Builder> result = PrivateIpAddressesCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressDetails.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressDetails> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressDetails... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressDetails.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses).map(c -> PrivateIpAddressDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final List<SecurityGroup.Builder> getSecurityGroups() {
            List<SecurityGroup.Builder> result = SecurityGroupsCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroup... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroup.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> SecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSubNetId() {
            return subNetId;
        }

        public final void setSubNetId(String subNetId) {
            this.subNetId = subNetId;
        }

        @Override
        public final Builder subNetId(String subNetId) {
            this.subNetId = subNetId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public Ec2NetworkInterface build() {
            return new Ec2NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
