/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the details of the ECS Cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsClusterDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EcsClusterDetails.Builder, EcsClusterDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EcsClusterDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(EcsClusterDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EcsClusterDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> ACTIVE_SERVICES_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActiveServicesCount").getter(getter(EcsClusterDetails::activeServicesCount))
            .setter(setter(Builder::activeServicesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeServicesCount").build())
            .build();

    private static final SdkField<Integer> REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RegisteredContainerInstancesCount")
            .getter(getter(EcsClusterDetails::registeredContainerInstancesCount))
            .setter(setter(Builder::registeredContainerInstancesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredContainerInstancesCount")
                    .build()).build();

    private static final SdkField<Integer> RUNNING_TASKS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RunningTasksCount").getter(getter(EcsClusterDetails::runningTasksCount))
            .setter(setter(Builder::runningTasksCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTasksCount").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(EcsClusterDetails::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EcsTaskDetails> TASK_DETAILS_FIELD = SdkField
            .<EcsTaskDetails> builder(MarshallingType.SDK_POJO).memberName("TaskDetails")
            .getter(getter(EcsClusterDetails::taskDetails)).setter(setter(Builder::taskDetails))
            .constructor(EcsTaskDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            STATUS_FIELD, ACTIVE_SERVICES_COUNT_FIELD, REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD, RUNNING_TASKS_COUNT_FIELD,
            TAGS_FIELD, TASK_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("arn", ARN_FIELD);
                    put("status", STATUS_FIELD);
                    put("activeServicesCount", ACTIVE_SERVICES_COUNT_FIELD);
                    put("registeredContainerInstancesCount", REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD);
                    put("runningTasksCount", RUNNING_TASKS_COUNT_FIELD);
                    put("tags", TAGS_FIELD);
                    put("taskDetails", TASK_DETAILS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String status;

    private final Integer activeServicesCount;

    private final Integer registeredContainerInstancesCount;

    private final Integer runningTasksCount;

    private final List<Tag> tags;

    private final EcsTaskDetails taskDetails;

    private EcsClusterDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.activeServicesCount = builder.activeServicesCount;
        this.registeredContainerInstancesCount = builder.registeredContainerInstancesCount;
        this.runningTasksCount = builder.runningTasksCount;
        this.tags = builder.tags;
        this.taskDetails = builder.taskDetails;
    }

    /**
     * <p>
     * The name of the ECS Cluster.
     * </p>
     * 
     * @return The name of the ECS Cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the cluster.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the ECS cluster.
     * </p>
     * 
     * @return The status of the ECS cluster.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The number of services that are running on the cluster in an ACTIVE state.
     * </p>
     * 
     * @return The number of services that are running on the cluster in an ACTIVE state.
     */
    public final Integer activeServicesCount() {
        return activeServicesCount;
    }

    /**
     * <p>
     * The number of container instances registered into the cluster.
     * </p>
     * 
     * @return The number of container instances registered into the cluster.
     */
    public final Integer registeredContainerInstancesCount() {
        return registeredContainerInstancesCount;
    }

    /**
     * <p>
     * The number of tasks in the cluster that are in the RUNNING state.
     * </p>
     * 
     * @return The number of tasks in the cluster that are in the RUNNING state.
     */
    public final Integer runningTasksCount() {
        return runningTasksCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags of the ECS Cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the ECS Cluster.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Contains information about the details of the ECS Task.
     * </p>
     * 
     * @return Contains information about the details of the ECS Task.
     */
    public final EcsTaskDetails taskDetails() {
        return taskDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(activeServicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(registeredContainerInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(runningTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsClusterDetails)) {
            return false;
        }
        EcsClusterDetails other = (EcsClusterDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(status(), other.status()) && Objects.equals(activeServicesCount(), other.activeServicesCount())
                && Objects.equals(registeredContainerInstancesCount(), other.registeredContainerInstancesCount())
                && Objects.equals(runningTasksCount(), other.runningTasksCount()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(taskDetails(), other.taskDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcsClusterDetails").add("Name", name()).add("Arn", arn()).add("Status", status())
                .add("ActiveServicesCount", activeServicesCount())
                .add("RegisteredContainerInstancesCount", registeredContainerInstancesCount())
                .add("RunningTasksCount", runningTasksCount()).add("Tags", hasTags() ? tags() : null)
                .add("TaskDetails", taskDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ActiveServicesCount":
            return Optional.ofNullable(clazz.cast(activeServicesCount()));
        case "RegisteredContainerInstancesCount":
            return Optional.ofNullable(clazz.cast(registeredContainerInstancesCount()));
        case "RunningTasksCount":
            return Optional.ofNullable(clazz.cast(runningTasksCount()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TaskDetails":
            return Optional.ofNullable(clazz.cast(taskDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EcsClusterDetails, T> g) {
        return obj -> g.apply((EcsClusterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcsClusterDetails> {
        /**
         * <p>
         * The name of the ECS Cluster.
         * </p>
         * 
         * @param name
         *        The name of the ECS Cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the cluster.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that identifies the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the ECS cluster.
         * </p>
         * 
         * @param status
         *        The status of the ECS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The number of services that are running on the cluster in an ACTIVE state.
         * </p>
         * 
         * @param activeServicesCount
         *        The number of services that are running on the cluster in an ACTIVE state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeServicesCount(Integer activeServicesCount);

        /**
         * <p>
         * The number of container instances registered into the cluster.
         * </p>
         * 
         * @param registeredContainerInstancesCount
         *        The number of container instances registered into the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredContainerInstancesCount(Integer registeredContainerInstancesCount);

        /**
         * <p>
         * The number of tasks in the cluster that are in the RUNNING state.
         * </p>
         * 
         * @param runningTasksCount
         *        The number of tasks in the cluster that are in the RUNNING state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningTasksCount(Integer runningTasksCount);

        /**
         * <p>
         * The tags of the ECS Cluster.
         * </p>
         * 
         * @param tags
         *        The tags of the ECS Cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags of the ECS Cluster.
         * </p>
         * 
         * @param tags
         *        The tags of the ECS Cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags of the ECS Cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.guardduty.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Contains information about the details of the ECS Task.
         * </p>
         * 
         * @param taskDetails
         *        Contains information about the details of the ECS Task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDetails(EcsTaskDetails taskDetails);

        /**
         * <p>
         * Contains information about the details of the ECS Task.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcsTaskDetails.Builder} avoiding the need
         * to create one manually via {@link EcsTaskDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcsTaskDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #taskDetails(EcsTaskDetails)}.
         * 
         * @param taskDetails
         *        a consumer that will call methods on {@link EcsTaskDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskDetails(EcsTaskDetails)
         */
        default Builder taskDetails(Consumer<EcsTaskDetails.Builder> taskDetails) {
            return taskDetails(EcsTaskDetails.builder().applyMutation(taskDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String status;

        private Integer activeServicesCount;

        private Integer registeredContainerInstancesCount;

        private Integer runningTasksCount;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private EcsTaskDetails taskDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsClusterDetails model) {
            name(model.name);
            arn(model.arn);
            status(model.status);
            activeServicesCount(model.activeServicesCount);
            registeredContainerInstancesCount(model.registeredContainerInstancesCount);
            runningTasksCount(model.runningTasksCount);
            tags(model.tags);
            taskDetails(model.taskDetails);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getActiveServicesCount() {
            return activeServicesCount;
        }

        public final void setActiveServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
        }

        @Override
        public final Builder activeServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
            return this;
        }

        public final Integer getRegisteredContainerInstancesCount() {
            return registeredContainerInstancesCount;
        }

        public final void setRegisteredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
        }

        @Override
        public final Builder registeredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
            return this;
        }

        public final Integer getRunningTasksCount() {
            return runningTasksCount;
        }

        public final void setRunningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
        }

        @Override
        public final Builder runningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EcsTaskDetails.Builder getTaskDetails() {
            return taskDetails != null ? taskDetails.toBuilder() : null;
        }

        public final void setTaskDetails(EcsTaskDetails.BuilderImpl taskDetails) {
            this.taskDetails = taskDetails != null ? taskDetails.build() : null;
        }

        @Override
        public final Builder taskDetails(EcsTaskDetails taskDetails) {
            this.taskDetails = taskDetails;
            return this;
        }

        @Override
        public EcsClusterDetails build() {
            return new EcsClusterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
