/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDetectorResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetDetectorResponse.Builder, GetDetectorResponse> {
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(GetDetectorResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FindingPublishingFrequency")
            .getter(getter(GetDetectorResponse::findingPublishingFrequencyAsString))
            .setter(setter(Builder::findingPublishingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingPublishingFrequency").build())
            .build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(GetDetectorResponse::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetDetectorResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedAt").getter(getter(GetDetectorResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<DataSourceConfigurationsResult> DATA_SOURCES_FIELD = SdkField
            .<DataSourceConfigurationsResult> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(GetDetectorResponse::dataSources)).setter(setter(Builder::dataSources))
            .constructor(DataSourceConfigurationsResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetDetectorResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<DetectorFeatureConfigurationResult>> FEATURES_FIELD = SdkField
            .<List<DetectorFeatureConfigurationResult>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(GetDetectorResponse::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectorFeatureConfigurationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectorFeatureConfigurationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            FINDING_PUBLISHING_FREQUENCY_FIELD, SERVICE_ROLE_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, DATA_SOURCES_FIELD,
            TAGS_FIELD, FEATURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("createdAt", CREATED_AT_FIELD);
                    put("findingPublishingFrequency", FINDING_PUBLISHING_FREQUENCY_FIELD);
                    put("serviceRole", SERVICE_ROLE_FIELD);
                    put("status", STATUS_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                    put("dataSources", DATA_SOURCES_FIELD);
                    put("tags", TAGS_FIELD);
                    put("features", FEATURES_FIELD);
                }
            });

    private final String createdAt;

    private final String findingPublishingFrequency;

    private final String serviceRole;

    private final String status;

    private final String updatedAt;

    private final DataSourceConfigurationsResult dataSources;

    private final Map<String, String> tags;

    private final List<DetectorFeatureConfigurationResult> features;

    private GetDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.serviceRole = builder.serviceRole;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.dataSources = builder.dataSources;
        this.tags = builder.tags;
        this.features = builder.features;
    }

    /**
     * <p>
     * The timestamp of when the detector was created.
     * </p>
     * 
     * @return The timestamp of when the detector was created.
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The publishing frequency of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return The publishing frequency of the finding.
     * @see FindingPublishingFrequency
     */
    public final FindingPublishingFrequency findingPublishingFrequency() {
        return FindingPublishingFrequency.fromValue(findingPublishingFrequency);
    }

    /**
     * <p>
     * The publishing frequency of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return The publishing frequency of the finding.
     * @see FindingPublishingFrequency
     */
    public final String findingPublishingFrequencyAsString() {
        return findingPublishingFrequency;
    }

    /**
     * <p>
     * The GuardDuty service role.
     * </p>
     * 
     * @return The GuardDuty service role.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The detector status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The detector status.
     * @see DetectorStatus
     */
    public final DetectorStatus status() {
        return DetectorStatus.fromValue(status);
    }

    /**
     * <p>
     * The detector status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The detector status.
     * @see DetectorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The last-updated timestamp for the detector.
     * </p>
     * 
     * @return The last-updated timestamp for the detector.
     */
    public final String updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Describes which data sources are enabled for the detector.
     * </p>
     * 
     * @return Describes which data sources are enabled for the detector.
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final DataSourceConfigurationsResult dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the detector resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the detector resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the features that have been enabled for the detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return Describes the features that have been enabled for the detector.
     */
    public final List<DetectorFeatureConfigurationResult> features() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(findingPublishingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDetectorResponse)) {
            return false;
        }
        GetDetectorResponse other = (GetDetectorResponse) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(findingPublishingFrequencyAsString(), other.findingPublishingFrequencyAsString())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(dataSources(), other.dataSources())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && hasFeatures() == other.hasFeatures()
                && Objects.equals(features(), other.features());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDetectorResponse").add("CreatedAt", createdAt())
                .add("FindingPublishingFrequency", findingPublishingFrequencyAsString()).add("ServiceRole", serviceRole())
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt()).add("DataSources", dataSources())
                .add("Tags", hasTags() ? tags() : null).add("Features", hasFeatures() ? features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "FindingPublishingFrequency":
            return Optional.ofNullable(clazz.cast(findingPublishingFrequencyAsString()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDetectorResponse, T> g) {
        return obj -> g.apply((GetDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDetectorResponse> {
        /**
         * <p>
         * The timestamp of when the detector was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the detector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The publishing frequency of the finding.
         * </p>
         * 
         * @param findingPublishingFrequency
         *        The publishing frequency of the finding.
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(String findingPublishingFrequency);

        /**
         * <p>
         * The publishing frequency of the finding.
         * </p>
         * 
         * @param findingPublishingFrequency
         *        The publishing frequency of the finding.
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency);

        /**
         * <p>
         * The GuardDuty service role.
         * </p>
         * 
         * @param serviceRole
         *        The GuardDuty service role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The detector status.
         * </p>
         * 
         * @param status
         *        The detector status.
         * @see DetectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The detector status.
         * </p>
         * 
         * @param status
         *        The detector status.
         * @see DetectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorStatus
         */
        Builder status(DetectorStatus status);

        /**
         * <p>
         * The last-updated timestamp for the detector.
         * </p>
         * 
         * @param updatedAt
         *        The last-updated timestamp for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(String updatedAt);

        /**
         * <p>
         * Describes which data sources are enabled for the detector.
         * </p>
         * 
         * @param dataSources
         *        Describes which data sources are enabled for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSources(DataSourceConfigurationsResult dataSources);

        /**
         * <p>
         * Describes which data sources are enabled for the detector.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfigurationsResult.Builder}
         * avoiding the need to create one manually via {@link DataSourceConfigurationsResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfigurationsResult.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSources(DataSourceConfigurationsResult)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link DataSourceConfigurationsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(DataSourceConfigurationsResult)
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        default Builder dataSources(Consumer<DataSourceConfigurationsResult.Builder> dataSources) {
            return dataSources(DataSourceConfigurationsResult.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * The tags of the detector resource.
         * </p>
         * 
         * @param tags
         *        The tags of the detector resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Describes the features that have been enabled for the detector.
         * </p>
         * 
         * @param features
         *        Describes the features that have been enabled for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<DetectorFeatureConfigurationResult> features);

        /**
         * <p>
         * Describes the features that have been enabled for the detector.
         * </p>
         * 
         * @param features
         *        Describes the features that have been enabled for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(DetectorFeatureConfigurationResult... features);

        /**
         * <p>
         * Describes the features that have been enabled for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorFeatureConfigurationResult.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorFeatureConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorFeatureConfigurationResult.Builder#build()} is
         * called immediately and its result is passed to {@link #features(List<DetectorFeatureConfigurationResult>)}.
         * 
         * @param features
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.DetectorFeatureConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(java.util.Collection<DetectorFeatureConfigurationResult>)
         */
        Builder features(Consumer<DetectorFeatureConfigurationResult.Builder>... features);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String createdAt;

        private String findingPublishingFrequency;

        private String serviceRole;

        private String status;

        private String updatedAt;

        private DataSourceConfigurationsResult dataSources;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<DetectorFeatureConfigurationResult> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDetectorResponse model) {
            super(model);
            createdAt(model.createdAt);
            findingPublishingFrequency(model.findingPublishingFrequency);
            serviceRole(model.serviceRole);
            status(model.status);
            updatedAt(model.updatedAt);
            dataSources(model.dataSources);
            tags(model.tags);
            features(model.features);
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getFindingPublishingFrequency() {
            return findingPublishingFrequency;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        @Override
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        @Override
        public final Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
            this.findingPublishingFrequency(findingPublishingFrequency == null ? null : findingPublishingFrequency.toString());
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DetectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Deprecated
        public final DataSourceConfigurationsResult.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(DataSourceConfigurationsResult.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(DataSourceConfigurationsResult dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<DetectorFeatureConfigurationResult.Builder> getFeatures() {
            List<DetectorFeatureConfigurationResult.Builder> result = DetectorFeatureConfigurationsResultsCopier
                    .copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<DetectorFeatureConfigurationResult.BuilderImpl> features) {
            this.features = DetectorFeatureConfigurationsResultsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<DetectorFeatureConfigurationResult> features) {
            this.features = DetectorFeatureConfigurationsResultsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(DetectorFeatureConfigurationResult... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<DetectorFeatureConfigurationResult.Builder>... features) {
            features(Stream.of(features).map(c -> DetectorFeatureConfigurationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDetectorResponse build() {
            return new GetDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
