/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of the highest severity threat detected during scan and number of infected files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HighestSeverityThreatDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<HighestSeverityThreatDetails.Builder, HighestSeverityThreatDetails> {
    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(HighestSeverityThreatDetails::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<String> THREAT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThreatName").getter(getter(HighestSeverityThreatDetails::threatName))
            .setter(setter(Builder::threatName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatName").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(HighestSeverityThreatDetails::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITY_FIELD,
            THREAT_NAME_FIELD, COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("severity", SEVERITY_FIELD);
                    put("threatName", THREAT_NAME_FIELD);
                    put("count", COUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String severity;

    private final String threatName;

    private final Integer count;

    private HighestSeverityThreatDetails(BuilderImpl builder) {
        this.severity = builder.severity;
        this.threatName = builder.threatName;
        this.count = builder.count;
    }

    /**
     * <p>
     * Severity level of the highest severity threat detected.
     * </p>
     * 
     * @return Severity level of the highest severity threat detected.
     */
    public final String severity() {
        return severity;
    }

    /**
     * <p>
     * Threat name of the highest severity threat detected as part of the malware scan.
     * </p>
     * 
     * @return Threat name of the highest severity threat detected as part of the malware scan.
     */
    public final String threatName() {
        return threatName;
    }

    /**
     * <p>
     * Total number of infected files with the highest severity threat detected.
     * </p>
     * 
     * @return Total number of infected files with the highest severity threat detected.
     */
    public final Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(threatName());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HighestSeverityThreatDetails)) {
            return false;
        }
        HighestSeverityThreatDetails other = (HighestSeverityThreatDetails) obj;
        return Objects.equals(severity(), other.severity()) && Objects.equals(threatName(), other.threatName())
                && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HighestSeverityThreatDetails").add("Severity", severity()).add("ThreatName", threatName())
                .add("Count", count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "ThreatName":
            return Optional.ofNullable(clazz.cast(threatName()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HighestSeverityThreatDetails, T> g) {
        return obj -> g.apply((HighestSeverityThreatDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HighestSeverityThreatDetails> {
        /**
         * <p>
         * Severity level of the highest severity threat detected.
         * </p>
         * 
         * @param severity
         *        Severity level of the highest severity threat detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(String severity);

        /**
         * <p>
         * Threat name of the highest severity threat detected as part of the malware scan.
         * </p>
         * 
         * @param threatName
         *        Threat name of the highest severity threat detected as part of the malware scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatName(String threatName);

        /**
         * <p>
         * Total number of infected files with the highest severity threat detected.
         * </p>
         * 
         * @param count
         *        Total number of infected files with the highest severity threat detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private String severity;

        private String threatName;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(HighestSeverityThreatDetails model) {
            severity(model.severity);
            threatName(model.threatName);
            count(model.count);
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final String getThreatName() {
            return threatName;
        }

        public final void setThreatName(String threatName) {
            this.threatName = threatName;
        }

        @Override
        public final Builder threatName(String threatName) {
            this.threatName = threatName;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        @Override
        public HighestSeverityThreatDetails build() {
            return new HighestSeverityThreatDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
