/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the role binding that grants the permission defined in a Kubernetes role.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesRoleBindingDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesRoleBindingDetails.Builder, KubernetesRoleBindingDetails> {
    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Kind")
            .getter(getter(KubernetesRoleBindingDetails::kind)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(KubernetesRoleBindingDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> UID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uid")
            .getter(getter(KubernetesRoleBindingDetails::uid)).setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()).build();

    private static final SdkField<String> ROLE_REF_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleRefName").getter(getter(KubernetesRoleBindingDetails::roleRefName))
            .setter(setter(Builder::roleRefName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleRefName").build()).build();

    private static final SdkField<String> ROLE_REF_KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleRefKind").getter(getter(KubernetesRoleBindingDetails::roleRefKind))
            .setter(setter(Builder::roleRefKind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleRefKind").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KIND_FIELD, NAME_FIELD,
            UID_FIELD, ROLE_REF_NAME_FIELD, ROLE_REF_KIND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("kind", KIND_FIELD);
                    put("name", NAME_FIELD);
                    put("uid", UID_FIELD);
                    put("roleRefName", ROLE_REF_NAME_FIELD);
                    put("roleRefKind", ROLE_REF_KIND_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String kind;

    private final String name;

    private final String uid;

    private final String roleRefName;

    private final String roleRefKind;

    private KubernetesRoleBindingDetails(BuilderImpl builder) {
        this.kind = builder.kind;
        this.name = builder.name;
        this.uid = builder.uid;
        this.roleRefName = builder.roleRefName;
        this.roleRefKind = builder.roleRefKind;
    }

    /**
     * <p>
     * The kind of the role. For role binding, this value will be <code>RoleBinding</code>.
     * </p>
     * 
     * @return The kind of the role. For role binding, this value will be <code>RoleBinding</code>.
     */
    public final String kind() {
        return kind;
    }

    /**
     * <p>
     * The name of the <code>RoleBinding</code>.
     * </p>
     * 
     * @return The name of the <code>RoleBinding</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier of the role binding.
     * </p>
     * 
     * @return The unique identifier of the role binding.
     */
    public final String uid() {
        return uid;
    }

    /**
     * <p>
     * The name of the role being referenced. This must match the name of the <code>Role</code> or
     * <code>ClusterRole</code> that you want to bind to.
     * </p>
     * 
     * @return The name of the role being referenced. This must match the name of the <code>Role</code> or
     *         <code>ClusterRole</code> that you want to bind to.
     */
    public final String roleRefName() {
        return roleRefName;
    }

    /**
     * <p>
     * The type of the role being referenced. This could be either <code>Role</code> or <code>ClusterRole</code>.
     * </p>
     * 
     * @return The type of the role being referenced. This could be either <code>Role</code> or <code>ClusterRole</code>
     *         .
     */
    public final String roleRefKind() {
        return roleRefKind;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kind());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        hashCode = 31 * hashCode + Objects.hashCode(roleRefName());
        hashCode = 31 * hashCode + Objects.hashCode(roleRefKind());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesRoleBindingDetails)) {
            return false;
        }
        KubernetesRoleBindingDetails other = (KubernetesRoleBindingDetails) obj;
        return Objects.equals(kind(), other.kind()) && Objects.equals(name(), other.name()) && Objects.equals(uid(), other.uid())
                && Objects.equals(roleRefName(), other.roleRefName()) && Objects.equals(roleRefKind(), other.roleRefKind());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesRoleBindingDetails").add("Kind", kind()).add("Name", name()).add("Uid", uid())
                .add("RoleRefName", roleRefName()).add("RoleRefKind", roleRefKind()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Kind":
            return Optional.ofNullable(clazz.cast(kind()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        case "RoleRefName":
            return Optional.ofNullable(clazz.cast(roleRefName()));
        case "RoleRefKind":
            return Optional.ofNullable(clazz.cast(roleRefKind()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesRoleBindingDetails, T> g) {
        return obj -> g.apply((KubernetesRoleBindingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesRoleBindingDetails> {
        /**
         * <p>
         * The kind of the role. For role binding, this value will be <code>RoleBinding</code>.
         * </p>
         * 
         * @param kind
         *        The kind of the role. For role binding, this value will be <code>RoleBinding</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kind(String kind);

        /**
         * <p>
         * The name of the <code>RoleBinding</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>RoleBinding</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier of the role binding.
         * </p>
         * 
         * @param uid
         *        The unique identifier of the role binding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(String uid);

        /**
         * <p>
         * The name of the role being referenced. This must match the name of the <code>Role</code> or
         * <code>ClusterRole</code> that you want to bind to.
         * </p>
         * 
         * @param roleRefName
         *        The name of the role being referenced. This must match the name of the <code>Role</code> or
         *        <code>ClusterRole</code> that you want to bind to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleRefName(String roleRefName);

        /**
         * <p>
         * The type of the role being referenced. This could be either <code>Role</code> or <code>ClusterRole</code>.
         * </p>
         * 
         * @param roleRefKind
         *        The type of the role being referenced. This could be either <code>Role</code> or
         *        <code>ClusterRole</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleRefKind(String roleRefKind);
    }

    static final class BuilderImpl implements Builder {
        private String kind;

        private String name;

        private String uid;

        private String roleRefName;

        private String roleRefKind;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesRoleBindingDetails model) {
            kind(model.kind);
            name(model.name);
            uid(model.uid);
            roleRefName(model.roleRefName);
            roleRefKind(model.roleRefKind);
        }

        public final String getKind() {
            return kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUid() {
            return uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getRoleRefName() {
            return roleRefName;
        }

        public final void setRoleRefName(String roleRefName) {
            this.roleRefName = roleRefName;
        }

        @Override
        public final Builder roleRefName(String roleRefName) {
            this.roleRefName = roleRefName;
            return this;
        }

        public final String getRoleRefKind() {
            return roleRefKind;
        }

        public final void setRoleRefKind(String roleRefKind) {
            this.roleRefKind = roleRefKind;
        }

        @Override
        public final Builder roleRefKind(String roleRefKind) {
            this.roleRefKind = roleRefKind;
            return this;
        }

        @Override
        public KubernetesRoleBindingDetails build() {
            return new KubernetesRoleBindingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
