/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Lambda function involved in the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaDetails implements SdkPojo, Serializable, ToCopyableBuilder<LambdaDetails.Builder, LambdaDetails> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn").getter(getter(LambdaDetails::functionArn)).setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionArn").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(LambdaDetails::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(LambdaDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedAt").getter(getter(LambdaDetails::lastModifiedAt)).setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(LambdaDetails::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionVersion").getter(getter(LambdaDetails::functionVersion))
            .setter(setter(Builder::functionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionVersion").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(LambdaDetails::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(LambdaDetails::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(LambdaDetails::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD,
            FUNCTION_NAME_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_AT_FIELD, REVISION_ID_FIELD, FUNCTION_VERSION_FIELD,
            ROLE_FIELD, VPC_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("functionArn", FUNCTION_ARN_FIELD);
                    put("functionName", FUNCTION_NAME_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
                    put("revisionId", REVISION_ID_FIELD);
                    put("functionVersion", FUNCTION_VERSION_FIELD);
                    put("role", ROLE_FIELD);
                    put("vpcConfig", VPC_CONFIG_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String functionArn;

    private final String functionName;

    private final String description;

    private final Instant lastModifiedAt;

    private final String revisionId;

    private final String functionVersion;

    private final String role;

    private final VpcConfig vpcConfig;

    private final List<Tag> tags;

    private LambdaDetails(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
        this.functionName = builder.functionName;
        this.description = builder.description;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.revisionId = builder.revisionId;
        this.functionVersion = builder.functionVersion;
        this.role = builder.role;
        this.vpcConfig = builder.vpcConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Lambda function.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Lambda function.
     */
    public final String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * Name of the Lambda function.
     * </p>
     * 
     * @return Name of the Lambda function.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Description of the Lambda function.
     * </p>
     * 
     * @return Description of the Lambda function.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when the Lambda function was last modified. This field is in the UTC date string format
     * <code>(2023-03-22T19:37:20.168Z)</code>.
     * </p>
     * 
     * @return The timestamp when the Lambda function was last modified. This field is in the UTC date string format
     *         <code>(2023-03-22T19:37:20.168Z)</code>.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The revision ID of the Lambda function version.
     * </p>
     * 
     * @return The revision ID of the Lambda function version.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The version of the Lambda function.
     * </p>
     * 
     * @return The version of the Lambda function.
     */
    public final String functionVersion() {
        return functionVersion;
    }

    /**
     * <p>
     * The execution role of the Lambda function.
     * </p>
     * 
     * @return The execution role of the Lambda function.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * Amazon Virtual Private Cloud configuration details associated with your Lambda function.
     * </p>
     * 
     * @return Amazon Virtual Private Cloud configuration details associated with your Lambda function.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags attached to this resource, listed in the format of <code>key</code>:<code>value</code> pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags attached to this resource, listed in the format of <code>key</code>:<code>value</code>
     *         pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaDetails)) {
            return false;
        }
        LambdaDetails other = (LambdaDetails) obj;
        return Objects.equals(functionArn(), other.functionArn()) && Objects.equals(functionName(), other.functionName())
                && Objects.equals(description(), other.description()) && Objects.equals(lastModifiedAt(), other.lastModifiedAt())
                && Objects.equals(revisionId(), other.revisionId()) && Objects.equals(functionVersion(), other.functionVersion())
                && Objects.equals(role(), other.role()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaDetails").add("FunctionArn", functionArn()).add("FunctionName", functionName())
                .add("Description", description()).add("LastModifiedAt", lastModifiedAt()).add("RevisionId", revisionId())
                .add("FunctionVersion", functionVersion()).add("Role", role()).add("VpcConfig", vpcConfig())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "FunctionVersion":
            return Optional.ofNullable(clazz.cast(functionVersion()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LambdaDetails, T> g) {
        return obj -> g.apply((LambdaDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaDetails> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Lambda function.
         * </p>
         * 
         * @param functionArn
         *        Amazon Resource Name (ARN) of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * Name of the Lambda function.
         * </p>
         * 
         * @param functionName
         *        Name of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Description of the Lambda function.
         * </p>
         * 
         * @param description
         *        Description of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when the Lambda function was last modified. This field is in the UTC date string format
         * <code>(2023-03-22T19:37:20.168Z)</code>.
         * </p>
         * 
         * @param lastModifiedAt
         *        The timestamp when the Lambda function was last modified. This field is in the UTC date string format
         *        <code>(2023-03-22T19:37:20.168Z)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The revision ID of the Lambda function version.
         * </p>
         * 
         * @param revisionId
         *        The revision ID of the Lambda function version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The version of the Lambda function.
         * </p>
         * 
         * @param functionVersion
         *        The version of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionVersion(String functionVersion);

        /**
         * <p>
         * The execution role of the Lambda function.
         * </p>
         * 
         * @param role
         *        The execution role of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Amazon Virtual Private Cloud configuration details associated with your Lambda function.
         * </p>
         * 
         * @param vpcConfig
         *        Amazon Virtual Private Cloud configuration details associated with your Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * Amazon Virtual Private Cloud configuration details associated with your Lambda function.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * A list of tags attached to this resource, listed in the format of <code>key</code>:<code>value</code> pair.
         * </p>
         * 
         * @param tags
         *        A list of tags attached to this resource, listed in the format of <code>key</code>:<code>value</code>
         *        pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags attached to this resource, listed in the format of <code>key</code>:<code>value</code> pair.
         * </p>
         * 
         * @param tags
         *        A list of tags attached to this resource, listed in the format of <code>key</code>:<code>value</code>
         *        pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags attached to this resource, listed in the format of <code>key</code>:<code>value</code> pair.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.guardduty.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String functionArn;

        private String functionName;

        private String description;

        private Instant lastModifiedAt;

        private String revisionId;

        private String functionVersion;

        private String role;

        private VpcConfig vpcConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaDetails model) {
            functionArn(model.functionArn);
            functionName(model.functionName);
            description(model.description);
            lastModifiedAt(model.lastModifiedAt);
            revisionId(model.revisionId);
            functionVersion(model.functionVersion);
            role(model.role);
            vpcConfig(model.vpcConfig);
            tags(model.tags);
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getFunctionVersion() {
            return functionVersion;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LambdaDetails build() {
            return new LambdaDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
